
;  SG-1000, FG-1000 & a few MarkIII ROM Loader for

; MSX + Musical Memory Mapper or Playsoniq cartridge

;              Version 0.91 by GDX

; Assembled with zasm cross assembler
; http://sourceforge.net/projects/zasm/

BDOS	equ	00005h
BUFTOP	equ	03000h
CALSLT	equ	0001Ch
CR	equ	0Dh
DMA	equ	00080h
ENASLT	equ	00024h
FCB	equ	0005ch
Joypads	equ	0F420h
LF	equ	0Ah
MNROM	equ	0FCC1h
MSXVER	equ	0002dh
RAMAD2	equ	0F343h
RDSLT	equ	0000Ch
WRSLT	equ	00014h

	org	0100h

	jp	Prog
MainMessage:
	db	"SG-1000 ROM Loader",LF,CR
	db	"v0.91 by GDX",LF,CR,LF,CR
	db	"Loading...",LF,CR,"$"

WaitMessage:
	db	"WAIT",0

FileNotFound:
	db	"File not found!$"

CALMNROM:
	ld	iy,(MNROM-1)
	jp	CALSLT

Prog:
	ld	c,9
	ld	de,MainMessage
	call	BDOS		; Print Main Message

	ld	bc,24		; Prepare the FCB
	ld	de,FCB+13
	ld	hl,FCB+12
	ld	(hl),b
	ldir			; Initialize the second half with zero

	ld	c,0Fh
	ld	de,FCB
	call	BDOS		; Open file
	ld	hl,1
	ld	(FCB+14),hl	; Record size = 1 byte
	ld	de,FileNotFound
	or	a
	jp	nz,ExitFromSG1000	; Jump if File not found

	ld	c,1ah
	ld	de,BUFTOP
	call	BDOS		; Set disk transfer address (buffer start at BUFTOP)

	ld	c,27h
	ld	de,FCB
	ld	hl,0A000h	; Number of records to read
	call	BDOS		; Read a block in file (40Ko max.)

LoadComplete:
	ld	H,080h
	call	MMM_Srch	; MMM detection

	cp	0ffh
	jr	z,No_MMM

	ld	a,080h
	out	(03Ch),a
	ld	a,040h
	ld	(0803Ch),a	; Enable SN76489AN port of MMM
No_MMM:
	ld	a,01Eh		;
	out	(02Ah),a	; Add
	ld	a,03Fh		; Playsoniq
	out	(02Bh),a	; support

	ld	b,4
	ld	a,09Fh
Volume0:
	out	(03Fh),a	; Set the
	add	a,020h		; volume of SN76489AN
	djnz	Volume0		; to zero

	ld	h,80h		; Restore the slot of bank 08000h~0BFFFh
	ld	a,(RAMAD2)
	call	ENASLT

	xor	a
	ld	(0FCA9h),a	; Hide cursor
	ld	(0F3EAh),a	; Border color = 0
	ld	(0F3EBh),a	; Border color = 0
	inc	a
	ld	ix,005Fh
	call	CALMNROM	; SCREEN 1 mode

	ld	a,11
	ld	(0F3DCh),a	; x curcor
	ld	a,13
	ld	(0F3DDh),a	; y curcor
	ld	hl,WaitMessage
PrintWait:
	ld	a,(HL)		; Border color = 0
	ld	ix,00A2h
	call	CALMNROM	; Print a character
	inc	hl
	xor	a
	cp	(hl)
	jr	nz,PrintWait

	di
; Replace "OUT 0BEh,A", "IN A,(0BEh)", "OUT 0BFh,A" and "IN A,(0BFh)"
; by "OUT 098h,A", "IN A,(098h)", "OUT 099h,A" and "IN A,(099h)"

	ld	hl,BUFTOP
	ld	bc,0A000h
PatchVDPport:
	ld	a,(hl)
	cp	0D3h
	jr	z,CheckValue
	cp	0DBh
	jr	nz,No_In_Out
CheckValue:
	inc	hl
	ld	a,(hl)
	cp	0BEh
	jr	nz,No_0BEH
	ld	(hl),098h
No_0BEH:
	cp	0BFh
	jr	nz,No_In_Out
	ld	(hl),099h
No_In_Out:
	inc	hl
	dec	bc
	ld	a,b
	or	c
	jr	nz,PatchVDPport

	ld	ix,PacthesLOC
	ld	b,(ix+0)
PatchBCL:
	inc	ix
	ld	l,(ix+0)
	inc	ix
	ld	h,(ix+0)
	push	bc
	call	ROMpatch
	pop	bc
	djnz	PatchBCL

	ld	hl,ExeRoutine
	ld	de,0F000h
	ld	bc,042h
	ldir			; Move ROM copy routine

	ld	hl,MSXVER
	ld	a,(0FCC1H)	; A = Main ROM Slot number
	call	RDSLT		; Read MSXVER
	cp	3
	di
	jp	nz,0F000h	; Jump to ROM copy routine if not Turbo R

	ld	a,080h
	ld	ix,00180h
	call	CALMNROM	; Z80 mode

	di
	jp	0F000h		; Jump to moved ROM copy routine

ExitFromSG1000:
	ld	c,9
	jp	BDOS		; Print FileNotFound message and exit

; Musical Memory Mapper Search Routine
;
; Input: HL = address bank (8000h~BFFFh)
; Output: A = Slot number (0FFh if not found)

MMM_Srch:
	ld	l,0FFh
	ld	b,16

MMM_Srch_Loop:
	push	hl

	ld	a,b
	dec	a
	and	3

	ld	hl,MNROM
	add	a,l
	ld	l,a

	ld	a,b
	dec	a
	or	(hl)

	pop    hl

	jp	m,Sec_SLT	; Jump if secondary Slot

	and	%00001111
	cp	4
	jr	nc,NextMMM_Srch ; Jump if 3-3 Slot

Sec_SLT:
	ld	c,a

	push	bc
	push	hl
	call	ENASLT		; Slot to search
	pop	hl
	pop	bc

	di

	ld	a,080h
	out	(03Ch),a	; Enable acces to registers by memory address mode

	ld	a,(hl)
	and	%00011111
	inc	a

	out	(0FFh),a

	or	%11000000
	cp	(hl)		; Same value?

	ld	a,0
	out	(03Ch),a
	out	(0FFh),a	; Restore initial mapper page in bank 0C000H~0FFFFH

	ei

	ld	a,c		; A = Found Slot Number (F000SSPP)
	jr	z,MMM_Found

NextMMM_Srch:
	djnz	MMM_Srch_Loop	; Jump if MMM is not found

	ld	a,0FFh		; MMM not found value
	ret

MMM_Found:
	dec	b
	ret

; Routine to patch Megaroms

ROMpatch:
	ld	b,(hl)		; B = Number of patch
	push	hl
VERdata:
	inc	hl
	ld	c,(hl)		; C = Original value in Rom
	inc	hl
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl		; hl = address to apply patch
	ld	a,c
	cp	(hl)
	jr	nz,NOpatch	; Jump if a data differs
	ex	de,hl
	djnz	VERdata
	pop	hl
	ld	b,(hl)
BCLpatch:
	inc	hl
	inc	hl
	ld	c,(hl)		; B = New value
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl		; hl = address to apply patch
	ld	(hl),c		; change select page address
	ex	de,hl
	djnz	BCLpatch
	ret
NOpatch:
	pop	hl
	ret
	
ExeRoutine:
	ld	hl,Joypad1
	ld	de,Joypads
	ld	bc,041h
	ldir

	ld	hl,BUFTOP
	ld	de,0000h
	ld	bc,0c000h
	ldir			; Set ROM at 0000h

	ld	hl,0C000h
	ld	(hl),0
	ld	de,0C001h
	ld	bc,301Fh
	ldir			; Init RAM
	ld	hl,0F460h
	ld	(hl),0
	ld	de,0F461h
	ld	bc,0B6Fh
	ldir			; Init RAM

	ld	a,15
	out	(0A0h),a
	in	a,(0A2h)	; Read register 15
	and	08Fh		; and 10001111
	out	(0A1h),a	; Select joystick port 1

	ld	a,14
	out	(0A0h),a	; Prepare to read always joystick port 1 with R#14

	rst	0		; Execute SG ROM

; Game patches location
; db number of patches
; dw address of patch

PacthesLOC:
	db	85
	dw	BankPanic,Bombjack,BorderLine,BubbleBobble,ChallengeDerby,C_SO,ChackNpop,ChampionBilliards
	dw	ChampionBaseball,ChampionBoxing,ChampionBoxMyCard,ChampionGolf,ChampionIceHockey
	dw	ChampionSoccer,Choplifter,CongoBongo,CongoBongoEU,DokiDokiPenguin,DragonWang,DrHello,Drol
	dw	Eagles5,ElevatorAction,FAtetris,Flashpoint,Flicky,FlickyR1,Flipper,Flipper40,Galaga16
	dw	Galaga40,GirlsGarden,Golgo13,GPWorld,GunSmoke,Guzzler,HangOnII,Hero,HustleChumy,HyperSport
	dw	JamesBond007v26,JamesBond007v27,KingValley,LodeRunner,Mahjong,MicroXevious,MonacoGP
	dw	MonacoGPr1,MonacoGPr2,NewBoggleBoggle2,NinjaPrincess,Nsub,OkamotoAyakoGolf,Orguss,Othello
	dw	Pacar,Pachinko,Pachinko2,Pitfall2,PopFlamer,PowerBoggle,Puznic,QBert,OkamotoAyakoGolfR1
	dw	RocknBolt,SafariHunt,SafariRace,SanNinMahjong,SerizawaTsumeshogi,ShinnyushainTooruKun
	dw	SpaceArmor,SpaceInvaders,SpaceMountain,StarForce,StarJackerV12,SuperTank,TheBlackOnyx
	dw	TheCastle,ThreeDragonStory,WonderBoy,WonderBoyV1,Yamato,Zaxxon,ZippyRace,Zoom909

; ROM Patch data

; db number of patch
; db original value, new value,address FSB,address MSB, etc...
; (Data address = Real address + 2000h if address < 0B000h)

BankPanic:
	db	18
	db	00Eh,0DBh,076h,04Dh, 0DCh,0A2h,077h,04Dh, 0EDh,0F6h,078h,04Dh, 0A2h,0C0h,079h,04Dh
	db	00Ch,077h,07Ah,04Dh, 0EDh,023h,07Bh,04Dh, 0A2h,03Eh,07Ch,04Dh, 03Eh,0FFh,07Dh,04Dh
	db	0FFh,077h,07Eh,04Dh, 0DCh,0A2h,0D4h,04Dh, 0DBh,03Eh,0D8h,04Dh, 0DDh,0FFh,0D9h,04Dh
	db	07Fh,03Fh,0C0h,05Fh, 07Fh,03Fh,0C4h,05Fh, 07Fh,03Fh,0C8h,05Fh, 07Fh,03Fh,0CCh,05Fh
	db	07Fh,03Fh,030h,0A5h, 07Fh,03Fh,04Ch,0A5h

Bombjack:
	db	8
	db	0DBh,03Eh,075h,037h, 0DDh,0FFh,076h,037h, 0DBh,0DBh,07Bh,037h, 0DCh,0A2h,07Ch,037h
	db	07Fh,03Fh,089h,0A3h, 07Fh,03Fh,09Fh,0A3h, 07Fh,03Fh,0ADh,0A3h, 07Fh,03Fh,0B2h,0A3h

BorderLine:
	db	14
	db	07Fh,03Fh,08Bh,030h, 07Fh,03Fh,08Fh,030h, 07Fh,03Fh,093h,030h, 07Fh,03Fh,097h,030h
	db	07Fh,03Fh,0C5h,032h, 0BFh,099h,0D7h,032h, 0DCh,0A2h,063h,039h, 07Fh,03Fh,046h,067h
	db	07Fh,03Fh,0A3h,067h, 07Fh,03Fh,0DFh,067h, 07Fh,03Fh,07Ch,06Ah, 07Fh,03Fh,08Fh,06Ah
	db	07Fh,03Fh,0A2h,06Ah, 07Fh,03Fh,0B5h,06Ah

BubbleBobble:
	db	35
	db	000h,0C3h,010h,030h, 000h,020h,011h,030h, 000h,0F4h,012h,030h, 000h,0C3h,018h,030h
	db	000h,04Ch,019h,030h, 000h,0F4h,01Ah,030h, 07Fh,03Fh,09Eh,031h, 07Fh,03Fh,0C1h,031h
	db	07Fh,03Fh,0D4h,031h, 07Fh,03Fh,0E4h,031h, 07Fh,03Fh,006h,032h, 07Fh,03Fh,00Eh,032h
	db	0DBh,000h,028h,032h, 0DCh,0D7h,029h,032h, 0DBh,000h,034h,032h, 0DCh,0D7h,035h,032h
	db	0DBh,000h,037h,032h, 0DDh,0DFh,038h,032h, 0DBh,000h,067h,032h, 0DDh,0DFh,068h,032h
	db	0DBh,000h,070h,032h, 0DCh,0D7h,071h,032h, 0DBh,000h,076h,032h, 0DDh,0DFh,077h,032h
	db	0DBh,000h,07Ch,032h, 0DCh,0D7h,07Dh,032h, 0DBh,000h,032h,037h, 0DCh,0D7h,033h,037h
	db	0DBh,000h,03Bh,037h, 0DCh,0D7h,03Ch,037h, 0DBh,000h,03Eh,037h, 0DDh,0DFh,03Fh,037h
	db	0CDh,0C3h,0D1h,04Fh, 0B7h,0D5h,0D2h,04Fh, 000h,01Fh,0D3h,04Fh

C_SO:
	db	10
	db	0DCh,0A2h,029h,034h, 0DCh,0A2h,0E9h,03Dh, 0DBh,03Eh,0EDh,03Dh, 0DDh,0FFh,0EEh,03Dh
	db	0DBh,03Eh,032h,08Fh, 0DDh,0FFh,033h,08Fh, 07Fh,03Fh,0AFh,0A5h, 07Fh,03Fh,0B5h,0A5h
	db	07Fh,03Fh,0C1h,0A5h, 07Fh,03Fh,047h,0A8h

ChackNpop:
	db	6
	db	0B8h,0B8h,00Ah,030h, 0DBh,03Eh,0C2h,053h, 0DDh,0FFh,0C3h,053h, 0DCh,0A2h,0C9h,053h
	db	07Fh,03Fh,043h,0A2h, 07Fh,03Fh,056h,0A2h

ChallengeDerby:
	db	20
	db	0BFh,099h,022h,031h, 0BFh,099h,036h,031h, 0BFh,099h,050h,031h, 0DCh,0A2h,0E9h,032h
	db	0DBh,03Eh,0F1h,032h, 0DDh,0FFh,0F2h,032h, 0DCh,0A2h,012h,033h, 0DCh,0A2h,01Eh,033h
	db	0DCh,0A2h,02Ah,033h, 0DCh,0A2h,036h,033h, 0DCh,0A2h,042h,033h, 0DBh,03Eh,05Bh,033h
	db	0DDh,0FFh,05Ch,033h, 0DBh,03Eh,067h,033h, 0DDh,0FFh,068h,033h, 0DCh,0A2h,074h,033h
	db	0DCh,0A2h,080h,033h, 0DCh,0A2h,08Ch,033h, 07Fh,03Fh,0EFh,034h, 07Fh,03Fh,035h,035h

ChampionBaseball:	; 2 players supported
	db	16
	db	0BFh,099h,056h,032h, 0D3h,000h,0AEh,038h, 0DEh,0CDh,0AFh,038h, 0DBh,020h,0B0h,038h
	db	0DCh,0F4h,0B1h,038h, 0D3h,000h,0BFh,038h, 0DEh,0CDh,0C0h,038h, 0DBh,04Ch,0C1h,038h
	db	0DDh,0F4h,0C2h,038h, 07Fh,03Fh,078h,03Ah, 07Fh,03Fh,090h,03Ah, 07Fh,03Fh,00Eh,03Dh
	db	07Fh,03Fh,02Fh,03Dh, 07Fh,03Fh,035h,03Dh, 0BFh,099h,002h,059h, 0BEh,098h,00Ah,059h

ChampionBilliards:
	db	17
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 07Fh,03Fh,01Bh,030h, 0BEh,098h,00Eh,031h
	db	0DCh,0A2h,0B8h,031h, 0DCh,0A2h,0F3h,031h, 0DBh,03Eh,0FAh,031h, 0DDh,0FFh,0FBh,031h
	db	0DCh,0A2h,00Ah,032h, 0DBh,03Eh,015h,032h, 0DDh,0FFh,016h,032h, 07Fh,03Fh,05Fh,0A3h
	db	07Fh,03Fh,065h,0A3h, 07Fh,03Fh,071h,0A3h, 07Fh,03Fh,087h,0A3h, 07Fh,03Fh,08Fh,0A3h
	db	07Fh,03Fh,063h,0A6h

ChampionBoxing:
	db	84
	db	0BFh,099h,02Bh,030h, 021h,0C3h,02Ch,030h, 03Bh,0F0h,02Dh,030h, 000h,07Fh,02Eh,030h
	db	0B3h,0C3h,030h,030h, 0C3h,04Ch,031h,030h, 070h,0F4h,032h,030h, 0BEh,098h,0B2h,041h
	db	07Fh,03Fh,03Fh,04Dh, 07Fh,03Fh,052h,04Dh, 012h,014h,05Fh,05Ah, 0DBh,0CDh,060h,05Ah
	db	0DCh,020h,061h,05Ah, 04Fh,0F4h,062h,05Ah, 0F6h,04Fh,063h,05Ah, 0C0h,0F6h,064h,05Ah
	db	047h,0C0h,065h,05Ah, 0DBh,047h,066h,05Ah, 0DDh,0CDh,067h,05Ah, 0CBh,04Ch,068h,05Ah
	db	011h,0F4h,069h,05Ah, 017h,0CBh,06Ah,05Ah, 0CBh,011h,06Bh,05Ah, 011h,017h,06Ch,05Ah
	db	017h,0CBh,06Dh,05Ah, 0F6h,011h,06Eh,05Ah, 0C0h,017h,06Fh,05Ah, 04Fh,0F6h,070h,05Ah
	db	0C9h,0C0h,071h,05Ah, 001h,04Fh,072h,05Ah, 0FFh,0C9h,073h,05Ah, 0FFh,001h,074h,05Ah
	db	03Eh,0FFh,075h,05Ah, 006h,0FFh,076h,05Ah, 0D3h,000h,077h,05Ah, 0DEh,0CDh,078h,05Ah
	db	0DBh,020h,079h,05Ah, 0DCh,0F4h,07Ah,05Ah, 002h,003h,084h,05Ah, 0DBh,000h,087h,05Ah
	db	0DDh,0F7h,088h,05Ah, 002h,005h,08Ch,05Ah, 0D3h,000h,091h,05Ah, 0DEh,0CDh,092h,05Ah
	db	0DBh,020h,093h,05Ah, 0DCh,0F4h,094h,05Ah, 002h,003h,098h,05Ah, 0DBh,000h,09Bh,05Ah
	db	0DDh,0F7h,09Ch,05Ah, 002h,005h,0A0h,05Ah, 0D3h,000h,0A5h,05Ah, 0DEh,0CDh,0A6h,05Ah
	db	0DBh,020h,0A7h,05Ah, 0DCh,0F4h,0A8h,05Ah, 002h,005h,0ACh,05Ah, 0D3h,000h,0B1h,05Ah
	db	0DEh,0CDh,0B2h,05Ah, 0DBh,020h,0B3h,05Ah, 0DCh,0F4h,0B4h,05Ah, 002h,005h,0BEh,05Ah
	db	0D3h,000h,0C3h,05Ah, 0DEh,0CDh,0C4h,05Ah, 0DBh,020h,0C5h,05Ah, 0DCh,0F4h,0C6h,05Ah
	db	002h,005h,0D0h,05Ah, 0D3h,000h,0D5h,05Ah, 0DEh,0CDh,0D6h,05Ah, 0DBh,020h,0D7h,05Ah
	db	0DCh,0F4h,0D8h,05Ah, 002h,005h,0E2h,05Ah, 0D3h,000h,0E7h,05Ah, 0DEh,0CDh,0E8h,05Ah
	db	0DBh,020h,0E9h,05Ah, 0DCh,0F4h,0EAh,05Ah, 0DBh,000h,0F0h,05Ah, 0DDh,0F7h,0F1h,05Ah
	db	0FFh,021h,0F0h,0AFh, 0FFh,03Bh,0F1h,0AFh, 0FFh,000h,0F2h,0AFh, 0FFh,0EDh,0F3h,0AFh
	db	0FFh,0B3h,0F4h,0AFh, 0FFh,0C3h,0F5h,0AFh, 0FFh,070h,0F6h,0AFh, 0FFh,000h,0F7h,0AFh

ChampionBoxMyCard:
	db	84
	db	0BFh,099h,02Bh,030h, 021h,0C3h,02Ch,030h, 03Bh,0F0h,02Dh,030h, 000h,07Fh,02Eh,030h
	db	0B3h,0C3h,030h,030h, 0C3h,04Ch,031h,030h, 070h,0F4h,032h,030h, 0BEh,098h,0A3h,041h
	db	07Fh,03Fh,030h,04Dh, 07Fh,03Fh,043h,04Dh, 012h,014h,050h,05Ah, 0DBh,0CDh,051h,05Ah
	db	0DCh,020h,052h,05Ah, 04Fh,0F4h,053h,05Ah, 0F6h,04Fh,054h,05Ah, 0C0h,0F6h,055h,05Ah
	db	047h,0C0h,056h,05Ah, 0DBh,047h,057h,05Ah, 0DDh,0CDh,058h,05Ah, 0CBh,04Ch,059h,05Ah
	db	011h,0F4h,05Ah,05Ah, 017h,0CBh,05Bh,05Ah, 0CBh,011h,05Ch,05Ah, 011h,017h,05Dh,05Ah
	db	017h,0CBh,05Eh,05Ah, 0F6h,011h,05Fh,05Ah, 0C0h,017h,060h,05Ah, 04Fh,0F6h,061h,05Ah
	db	0C9h,0C0h,062h,05Ah, 001h,04Fh,063h,05Ah, 0FFh,0C9h,064h,05Ah, 0FFh,001h,065h,05Ah
	db	03Eh,0FFh,066h,05Ah, 006h,0FFh,067h,05Ah, 0D3h,000h,068h,05Ah, 0DEh,0CDh,069h,05Ah
	db	0DBh,020h,06Ah,05Ah, 0DCh,0F4h,06Bh,05Ah, 002h,003h,075h,05Ah, 0DBh,000h,078h,05Ah
	db	0DDh,0F7h,079h,05Ah, 002h,005h,07Dh,05Ah, 0D3h,000h,082h,05Ah, 0DEh,0CDh,083h,05Ah
	db	0DBh,020h,084h,05Ah, 0DCh,0F4h,085h,05Ah, 002h,003h,089h,05Ah, 0DBh,000h,08Ch,05Ah
	db	0DDh,0F7h,08Dh,05Ah, 002h,005h,091h,05Ah, 0D3h,000h,096h,05Ah, 0DEh,0CDh,097h,05Ah
	db	0DBh,020h,098h,05Ah, 0DCh,0F4h,099h,05Ah, 002h,005h,09Dh,05Ah, 0D3h,000h,0A2h,05Ah
	db	0DEh,0CDh,0A3h,05Ah, 0DBh,020h,0A4h,05Ah, 0DCh,0F4h,0A5h,05Ah, 002h,005h,0AFh,05Ah
	db	0D3h,000h,0B4h,05Ah, 0DEh,0CDh,0B5h,05Ah, 0DBh,020h,0B6h,05Ah, 0DCh,0F4h,0B7h,05Ah
	db	002h,005h,0C1h,05Ah, 0D3h,000h,0C6h,05Ah, 0DEh,0CDh,0C7h,05Ah, 0DBh,020h,0C8h,05Ah
	db	0DCh,0F4h,0C9h,05Ah, 002h,005h,0D3h,05Ah, 0D3h,000h,0D8h,05Ah, 0DEh,0CDh,0D9h,05Ah
	db	0DBh,020h,0DAh,05Ah, 0DCh,0F4h,0DBh,05Ah, 0DBh,000h,0E1h,05Ah, 0DDh,0F7h,0E2h,05Ah
	db	0FFh,021h,0F0h,0AFh, 0FFh,03Bh,0F1h,0AFh, 0FFh,000h,0F2h,0AFh, 0FFh,0EDh,0F3h,0AFh
	db	0FFh,0B3h,0F4h,0AFh, 0FFh,0C3h,0F5h,0AFh, 0FFh,070h,0F6h,0AFh, 0FFh,000h,0F7h,0AFh

ChampionGolf:	; 2 players supported
	db	21
	db	07Fh,03Fh,078h,030h, 07Fh,03Fh,07Ch,030h, 07Fh,03Fh,080h,030h, 07Fh,03Fh,084h,030h
	db	07Fh,03Fh,0F0h,034h, 07Fh,03Fh,003h,035h, 07Fh,03Fh,016h,035h, 07Fh,03Fh,029h,035h
	db	07Fh,03Fh,03Ch,035h, 007h,005h,0CBh,03Bh, 0D3h,0CDh,0D1h,03Bh, 0DEh,020h,0D2h,03Bh
	db	0DBh,0F4h,0D3h,03Bh, 0DCh,02Fh,0D4h,03Bh, 02Fh,0CDh,0D5h,03Bh, 0CDh,0E7h,0D6h,03Bh
	db	0E7h,00Bh,0D7h,03Bh, 00Bh,013h,0D8h,03Bh, 013h,0CDh,0D9h,03Bh, 0DBh,04Ch,0DAh,03Bh
	db	0DDh,0F4h,0DBh,03Bh

ChampionIceHockey:
	db	96
	db	0FFh,0C3h,010h,030h, 0FFh,020h,011h,030h, 0FFh,0F4h,012h,030h, 0FFh,0C3h,018h,030h
	db	0FFh,04Ch,019h,030h, 0FFh,0F4h,01Ah,030h, 07Fh,03Fh,05Ch,06Dh, 07Fh,03Fh,073h,06Dh
	db	0DBh,000h,054h,074h, 0DCh,0D7h,055h,074h, 0DBh,000h,05Eh,074h, 0DDh,0DFh,05Fh,074h
	db	0DBh,000h,06Bh,074h, 0DCh,0D7h,06Ch,074h, 0DBh,000h,079h,074h, 0DDh,0DFh,07Ah,074h
	db	0D3h,000h,08Bh,074h, 0DEh,0CDh,08Ch,074h, 0DBh,020h,08Dh,074h, 0DCh,0F4h,08Eh,074h
	db	0DBh,000h,094h,074h, 0DDh,0DFh,095h,074h, 0D3h,000h,0A3h,074h, 0DEh,0CDh,0A4h,074h
	db	0DBh,020h,0A5h,074h, 0DCh,0F4h,0A6h,074h, 0DBh,000h,0B3h,074h, 0DDh,0DFh,0B4h,074h
	db	0D3h,000h,0C8h,074h, 0DEh,0CDh,0C9h,074h, 0DBh,04Ch,0CAh,074h, 0DDh,0F4h,0CBh,074h
	db	002h,005h,0CFh,074h, 0D3h,000h,0D4h,074h, 0DEh,0CDh,0D5h,074h, 0DBh,04Ch,0D6h,074h
	db	0DDh,0F4h,0D7h,074h, 002h,005h,0DBh,074h, 0D3h,000h,0E0h,074h, 0DEh,0CDh,0E1h,074h
	db	0DBh,020h,0E2h,074h, 0DCh,0F4h,0E3h,074h, 002h,005h,0EDh,074h, 0D3h,000h,0F2h,074h
	db	0DEh,0CDh,0F3h,074h, 0DBh,020h,0F4h,074h, 0DCh,0F4h,0F5h,074h, 002h,005h,0F9h,074h
	db	0D3h,000h,0FEh,074h, 0DEh,0CDh,0FFh,074h, 0DBh,020h,000h,075h, 0DCh,0F4h,001h,075h
	db	0D3h,000h,00Ch,075h, 0DEh,0CDh,00Dh,075h, 0DBh,020h,00Eh,075h, 0DCh,0F4h,00Fh,075h
	db	002h,005h,013h,075h, 0D3h,000h,018h,075h, 0DEh,0CDh,019h,075h, 0DBh,020h,01Ah,075h
	db	0DCh,0F4h,01Bh,075h, 002h,005h,01Fh,075h, 0D3h,000h,024h,075h, 0DEh,0CDh,025h,075h
	db	0DBh,020h,026h,075h, 0DCh,0F4h,027h,075h, 002h,005h,02Bh,075h, 0D3h,000h,030h,075h
	db	0DEh,0CDh,031h,075h, 0DBh,020h,032h,075h, 0DCh,0F4h,033h,075h, 002h,005h,037h,075h
	db	0D3h,000h,03Ch,075h, 0DEh,0CDh,03Dh,075h, 0DBh,020h,03Eh,075h, 0DCh,0F4h,03Fh,075h
	db	002h,005h,049h,075h, 0D3h,000h,04Eh,075h, 0DEh,0CDh,04Fh,075h, 0DBh,020h,050h,075h
	db	0DCh,0F4h,051h,075h, 002h,005h,055h,075h, 0D3h,000h,05Ah,075h, 0DEh,0CDh,05Bh,075h
	db	0DBh,020h,05Ch,075h, 0DCh,0F4h,05Dh,075h, 002h,005h,061h,075h, 0D3h,000h,066h,075h
	db	0DEh,0CDh,067h,075h, 0DBh,04Ch,068h,075h, 0DDh,0F4h,069h,075h, 002h,005h,06Dh,075h
	db	0D3h,000h,072h,075h, 0DEh,0CDh,073h,075h, 0DBh,04Ch,074h,075h, 0DDh,0F4h,075h,075h

ChampionSoccer:
	db	11
	db	000h,0C3h,028h,030h, 000h,020h,029h,030h, 000h,0F4h,02Ah,030h, 0D3h,000h,083h,040h
	db	0DEh,0CDh,084h,040h, 0DBh,04Ch,085h,040h, 0DDh,0F4h,086h,040h, 0DBh,000h,08Bh,040h
	db	0DCh,0EFh,08Ch,040h, 07Fh,03Fh,098h,04Dh, 07Fh,03Fh,0ABh,04Dh

Choplifter:	; 2 players supported
	db	13
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 0D3h,0CDh,0D8h,039h, 0DEh,04Ch,0D9h,039h
	db	0DBh,0F4h,0DAh,039h, 0DDh,047h,0DBh,039h, 047h,0C3h,0DCh,039h, 0DBh,020h,0DDh,039h
	db	0DCh,0F4h,0DEh,039h, 07Fh,03Fh,055h,06Bh, 07Fh,03Fh,0E8h,06Bh, 07Fh,03Fh,0EAh,06Eh
	db	07Fh,03Fh,001h,06Fh

CongoBongo:
	db	19
	db	07Fh,03Fh,055h,034h, 07Fh,03Fh,059h,034h, 07Fh,03Fh,05Dh,034h, 07Fh,03Fh,061h,034h
	db	0DCh,0A2h,0F8h,046h, 0DCh,0A2h,020h,047h, 0DCh,0A2h,049h,047h, 0DCh,0A2h,055h,047h
	db	0DCh,0A2h,06Dh,047h, 07Fh,03Fh,0B4h,047h, 07Fh,03Fh,0B8h,047h, 07Fh,03Fh,0BCh,047h
	db	07Fh,03Fh,0C0h,047h, 07Fh,03Fh,0BAh,080h, 07Fh,03Fh,0CFh,080h, 07Fh,03Fh,0E1h,080h
	db	07Fh,03Fh,0E5h,080h, 07Fh,03Fh,0F7h,080h, 07Fh,03Fh,00Eh,081h

CongoBongoEU:
	db	21
	db	07Fh,03Fh,055h,034h, 07Fh,03Fh,059h,034h, 07Fh,03Fh,05Dh,034h, 07Fh,03Fh,061h,034h
	db	0DCh,0A2h,0E7h,046h, 0DCh,0A2h,00Fh,047h, 0DCh,0A2h,038h,047h, 0DCh,0A2h,044h,047h
	db	0DCh,0A2h,050h,047h, 0DCh,0A2h,05Ch,047h, 0DCh,0A2h,068h,047h, 07Fh,03Fh,0A3h,047h
	db	07Fh,03Fh,0A7h,047h, 07Fh,03Fh,0ABh,047h, 07Fh,03Fh,0AFh,047h, 07Fh,03Fh,0A9h,080h
	db	07Fh,03Fh,0BEh,080h, 07Fh,03Fh,0D0h,080h, 07Fh,03Fh,0D4h,080h, 07Fh,03Fh,0E6h,080h
	db	07Fh,03Fh,0FDh,080h

DokiDokiPenguin:	; 2 players supported
	db	79
	db	0FFh,0C3h,020h,030h, 0FFh,020h,021h,030h, 0FFh,0F4h,022h,030h, 0FFh,047h,028h,030h
	db	0FFh,0C3h,029h,030h, 0FFh,04Ch,02Ah,030h, 0FFh,0F4h,02Bh,030h, 0BEh,098h,074h,032h
	db	0DBh,000h,003h,034h, 0DCh,0E7h,004h,034h, 0DBh,000h,007h,034h, 0DCh,0E7h,008h,034h
	db	047h,0CDh,00Bh,034h, 0DBh,028h,00Ch,034h, 0DDh,000h,00Dh,034h, 09Ah,09Dh,047h,034h
	db	0D3h,000h,04Bh,034h, 0DEh,0CDh,04Ch,034h, 0DBh,020h,04Dh,034h, 0DCh,0F4h,04Eh,034h
	db	0D3h,000h,057h,034h, 0DEh,0CDh,058h,034h, 0DBh,020h,059h,034h, 0DCh,0F4h,05Ah,034h
	db	002h,005h,05Eh,034h, 0D3h,000h,063h,034h, 0DEh,0CDh,064h,034h, 0DBh,020h,065h,034h
	db	0DCh,0F4h,066h,034h, 002h,005h,070h,034h, 0D3h,000h,075h,034h, 0DEh,0CDh,076h,034h
	db	0DBh,020h,077h,034h, 0DCh,0F4h,078h,034h, 002h,005h,07Ch,034h, 0D3h,000h,081h,034h
	db	0DEh,0CDh,082h,034h, 0DBh,020h,083h,034h, 0DCh,0F4h,084h,034h, 002h,005h,088h,034h
	db	0D3h,000h,08Dh,034h, 0DEh,0CDh,08Eh,034h, 0DBh,020h,08Fh,034h, 0DCh,0F4h,090h,034h
	db	0D3h,000h,09Ch,034h, 0DEh,0CDh,09Dh,034h, 0DBh,020h,09Eh,034h, 0DCh,0F4h,09Fh,034h
	db	047h,0CDh,0A2h,034h, 0DBh,028h,0A3h,034h, 0DDh,000h,0A4h,034h, 0D3h,000h,0B2h,034h
	db	0DEh,0CDh,0B3h,034h, 0DBh,020h,0B4h,034h, 0DCh,0F4h,0B5h,034h, 002h,005h,0B9h,034h
	db	0D3h,000h,0BEh,034h, 0DEh,0CDh,0BFh,034h, 0DBh,020h,0C0h,034h, 0DCh,0F4h,0C1h,034h
	db	002h,005h,0C5h,034h, 0D3h,000h,0CAh,034h, 0DEh,0CDh,0CBh,034h, 0DBh,04Ch,0CCh,034h
	db	0DDh,0F4h,0CDh,034h, 002h,005h,0D1h,034h, 0D3h,000h,0D6h,034h, 0DEh,0CDh,0D7h,034h
	db	0DBh,04Ch,0D8h,034h, 0DDh,0F4h,0D9h,034h, 0BEh,098h,0EDh,063h, 07Fh,03Fh,0F7h,09Fh
	db	07Fh,03Fh,00Ch,0A0h, 07Fh,03Fh,024h,0A0h, 07Fh,03Fh,062h,0A0h, 07Fh,03Fh,086h,0A0h
	db	07Fh,03Fh,0E6h,0A0h, 07Fh,03Fh,0BDh,0A3h, 07Fh,03Fh,0D0h,0A3h

DrHello:	; 2 players supported
	db	63
	db	07Fh,03Fh,015h,030h, 07Fh,03Fh,0BBh,031h, 07Fh,03Fh,0E3h,031h, 07Fh,03Fh,0F6h,031h
	db	07Fh,03Fh,015h,032h, 07Fh,03Fh,038h,032h, 07Fh,03Fh,047h,032h, 0DBh,0CDh,052h,037h
	db	0DCh,020h,053h,037h, 0CBh,0F4h,054h,037h, 067h,0CBh,055h,037h, 0CAh,067h,056h,037h
	db	0BAh,028h,057h,037h, 007h,061h,058h,037h, 0DBh,0CDh,05Ch,037h, 0DDh,04Ch,05Dh,037h
	db	0CBh,0F4h,05Eh,037h, 057h,0CBh,05Fh,037h, 0CAh,057h,060h,037h, 0BAh,028h,061h,037h
	db	007h,057h,062h,037h, 0DBh,0CDh,066h,037h, 0DCh,020h,067h,037h, 0CBh,0F4h,068h,037h
	db	06Fh,0CBh,069h,037h, 0CAh,06Fh,06Ah,037h, 0BAh,028h,06Bh,037h, 007h,04Dh,06Ch,037h
	db	0DBh,0CDh,070h,037h, 0DDh,04Ch,071h,037h, 0CBh,0F4h,072h,037h, 05Fh,0CBh,073h,037h
	db	0CAh,05Fh,074h,037h, 0BAh,028h,075h,037h, 007h,043h,076h,037h, 0DBh,0CDh,07Ah,037h
	db	0DCh,020h,07Bh,037h, 0CBh,0F4h,07Ch,037h, 047h,0CBh,07Dh,037h, 0CAh,047h,07Eh,037h
	db	0B7h,028h,07Fh,037h, 007h,036h,080h,037h, 0DBh,0CDh,093h,037h, 0DCh,020h,094h,037h
	db	0CBh,0F4h,095h,037h, 077h,0CBh,096h,037h, 0CAh,077h,097h,037h, 0B7h,0CAh,098h,037h
	db	007h,0B7h,099h,037h, 0CBh,007h,09Ah,037h, 07Fh,0CBh,09Bh,037h, 0CAh,07Fh,09Ch,037h
	db	0B4h,028h,09Dh,037h, 007h,015h,09Eh,037h, 0DBh,0CDh,09Fh,037h, 0DDh,04Ch,0A0h,037h
	db	0CBh,0F4h,0A1h,037h, 047h,0CBh,0A2h,037h, 0CAh,047h,0A3h,037h, 0AEh,028h,0A4h,037h
	db	007h,008h,0A5h,037h, 07Fh,03Fh,092h,0AEh, 07Fh,03Fh,09Ah,0AEh

DragonWang:	; 2 players supported
	db	86
	db	000h,0C3h,010h,030h, 000h,020h,011h,030h, 000h,0F4h,012h,030h, 000h,0C3h,018h,030h
	db	000h,04Ch,019h,030h, 000h,0F4h,01Ah,030h, 07Fh,03Fh,0BAh,031h, 07Fh,03Fh,0BEh,031h
	db	07Fh,03Fh,0C2h,031h, 07Fh,03Fh,0C6h,031h, 07Fh,03Fh,0BCh,03Ah, 07Fh,03Fh,0C0h,03Ah
	db	07Fh,03Fh,0C4h,03Ah, 07Fh,03Fh,0C8h,03Ah, 0DBh,0C3h,094h,03Bh, 0DCh,020h,095h,03Bh
	db	0C9h,0F4h,096h,03Bh, 0DBh,000h,097h,03Bh, 0DCh,0D7h,098h,03Bh, 0DBh,000h,09Ch,03Bh
	db	0DDh,0DFh,09Dh,03Bh, 04Bh,04Fh,0A6h,03Bh, 0D3h,000h,0A9h,03Bh, 0DEh,0CDh,0AAh,03Bh
	db	0DBh,020h,0ABh,03Bh, 0DCh,0F4h,0ACh,03Bh, 0D3h,000h,0B0h,03Bh, 0DEh,0CDh,0B1h,03Bh
	db	0DBh,020h,0B2h,03Bh, 0DCh,0F4h,0B3h,03Bh, 002h,005h,0B7h,03Bh, 0D3h,000h,0BCh,03Bh
	db	0DEh,0CDh,0BDh,03Bh, 0DBh,020h,0BEh,03Bh, 0DCh,0F4h,0BFh,03Bh, 002h,005h,0C3h,03Bh
	db	0D3h,000h,0C8h,03Bh, 0DEh,0CDh,0C9h,03Bh, 0DBh,020h,0CAh,03Bh, 0DCh,0F4h,0CBh,03Bh
	db	002h,005h,0D5h,03Bh, 0D3h,000h,0DAh,03Bh, 0DEh,0CDh,0DBh,03Bh, 0DBh,020h,0DCh,03Bh
	db	0DCh,0F4h,0DDh,03Bh, 002h,005h,0E1h,03Bh, 0D3h,000h,0E6h,03Bh, 0DEh,0CDh,0E7h,03Bh
	db	0DBh,020h,0E8h,03Bh, 0DCh,0F4h,0E9h,03Bh, 0D3h,000h,0FCh,03Bh, 0DEh,0CDh,0FDh,03Bh
	db	0DBh,020h,0FEh,03Bh, 0DCh,0F4h,0FFh,03Bh, 002h,005h,009h,03Ch, 0D3h,000h,00Eh,03Ch
	db	0DEh,0CDh,00Fh,03Ch, 0DBh,020h,010h,03Ch, 0DCh,0F4h,011h,03Ch, 002h,005h,015h,03Ch
	db	0D3h,000h,01Ah,03Ch, 0DEh,0CDh,01Bh,03Ch, 0DBh,020h,01Ch,03Ch, 0DCh,0F4h,01Dh,03Ch
	db	002h,005h,021h,03Ch, 0D3h,000h,026h,03Ch, 0DEh,0CDh,027h,03Ch, 0DBh,04Ch,028h,03Ch
	db	0DDh,0F4h,029h,03Ch, 002h,005h,02Dh,03Ch, 0D3h,000h,032h,03Ch, 0DEh,0CDh,033h,03Ch
	db	0DBh,04Ch,034h,03Ch, 0DDh,0F4h,035h,03Ch, 07Fh,03Fh,04Dh,06Fh, 07Fh,03Fh,065h,06Fh
	db	07Fh,03Fh,07Dh,06Fh, 07Fh,03Fh,093h,06Fh, 07Fh,03Fh,0A9h,06Fh, 07Fh,03Fh,0CDh,06Fh
	db	07Fh,03Fh,0EAh,06Fh, 07Fh,03Fh,0F6h,06Fh, 07Fh,03Fh,05Eh,070h, 07Fh,03Fh,076h,070h
	db	07Fh,03Fh,058h,073h, 07Fh,03Fh,06Bh,073h

Drol:
	db	13
	db	07Fh,03Fh,046h,030h, 07Fh,03Fh,04Ah,030h, 07Fh,03Fh,04Eh,030h, 07Fh,03Fh,052h,030h
	db	0BEh,098h,0CEh,031h, 0DCh,0A2h,0E3h,032h, 0DCh,0A2h,0F2h,032h, 0DCh,0A2h,0FEh,032h
	db	0DCh,0A2h,00Ah,033h, 0DCh,0A2h,016h,033h, 0DCh,0A2h,022h,033h, 07Fh,03Fh,066h,076h
	db	07Fh,03Fh,079h,076h

Eagles5:
	db	10
	db	0DCh,0A2h,03Ah,0AAh, 0DBh,03Eh,03Fh,0AAh, 0DCh,0FFh,040h,0AAh, 0DBh,03Eh,046h,0AAh
	db	0DDh,0FFh,047h,0AAh, 07Fh,03Fh,096h,0AAh, 07Fh,03Fh,0BAh,0AAh, 07Fh,03Fh,0CDh,0AAh
	db	07Fh,03Fh,0DBh,0AAh, 07Fh,03Fh,012h,0ABh

ElevatorAction:	; 2 players supported
	db	113
	db	0FFh,0C3h,020h,030h, 0FFh,020h,021h,030h, 0FFh,0F4h,022h,030h, 0FFh,0C3h,028h,030h
	db	0FFh,04Ch,029h,030h, 0FFh,0F4h,02Ah,030h, 0DBh,000h,088h,049h, 0DCh,0E7h,089h,049h
	db	0DBh,000h,094h,049h, 0DDh,0EFh,095h,049h, 0DBh,000h,0A1h,049h, 0DCh,0E7h,0A2h,049h
	db	002h,003h,0ACh,049h, 0DBh,000h,0AFh,049h, 0DDh,0EFh,0B0h,049h, 0D3h,000h,0C5h,049h
	db	0DEh,0CDh,0C6h,049h, 0DBh,020h,0C7h,049h, 0DCh,0F4h,0C8h,049h, 0DBh,000h,0CEh,049h
	db	0DDh,0EFh,0CFh,049h, 0D3h,000h,0DDh,049h, 0DEh,0CDh,0DEh,049h, 0DBh,020h,0DFh,049h
	db	0DCh,0F4h,0E0h,049h, 0DBh,000h,0EDh,049h, 0DDh,0EFh,0EEh,049h, 044h,047h,0FFh,049h
	db	0DBh,000h,004h,04Ah, 0DDh,0EFh,005h,04Ah, 002h,005h,009h,04Ah, 0D3h,000h,00Eh,04Ah
	db	0DEh,0CDh,00Fh,04Ah, 0DBh,04Ch,010h,04Ah, 0DDh,0F4h,011h,04Ah, 002h,005h,015h,04Ah
	db	0D3h,000h,01Ah,04Ah, 0DEh,0CDh,01Bh,04Ah, 0DBh,020h,01Ch,04Ah, 0DCh,0F4h,01Dh,04Ah
	db	002h,005h,027h,04Ah, 0D3h,000h,02Ch,04Ah, 0DEh,0CDh,02Dh,04Ah, 0DBh,020h,02Eh,04Ah
	db	0DCh,0F4h,02Fh,04Ah, 002h,005h,033h,04Ah, 0D3h,000h,038h,04Ah, 0DEh,0CDh,039h,04Ah
	db	0DBh,020h,03Ah,04Ah, 0DCh,0F4h,03Bh,04Ah, 046h,049h,03Fh,04Ah, 042h,045h,043h,04Ah
	db	0D3h,000h,046h,04Ah, 0DEh,0CDh,047h,04Ah, 0DBh,020h,048h,04Ah, 0DCh,0F4h,049h,04Ah
	db	002h,005h,04Dh,04Ah, 0D3h,000h,052h,04Ah, 0DEh,0CDh,053h,04Ah, 0DBh,020h,054h,04Ah
	db	0DCh,0F4h,055h,04Ah, 002h,005h,059h,04Ah, 0D3h,000h,05Eh,04Ah, 0DEh,0CDh,05Fh,04Ah
	db	0DBh,020h,060h,04Ah, 0DCh,0F4h,061h,04Ah, 002h,005h,065h,04Ah, 0D3h,000h,06Ah,04Ah
	db	0DEh,0CDh,06Bh,04Ah, 0DBh,020h,06Ch,04Ah, 0DCh,0F4h,06Dh,04Ah, 002h,005h,071h,04Ah
	db	0D3h,000h,076h,04Ah, 0DEh,0CDh,077h,04Ah, 0DBh,020h,078h,04Ah, 0DCh,0F4h,079h,04Ah
	db	002h,005h,083h,04Ah, 0D3h,000h,088h,04Ah, 0DEh,0CDh,089h,04Ah, 0DBh,020h,08Ah,04Ah
	db	0DCh,0F4h,08Bh,04Ah, 002h,005h,08Fh,04Ah, 0D3h,000h,094h,04Ah, 0DEh,0CDh,095h,04Ah
	db	0DBh,020h,096h,04Ah, 0DCh,0F4h,097h,04Ah, 002h,005h,09Bh,04Ah, 0D3h,000h,0A0h,04Ah
	db	0DEh,0CDh,0A1h,04Ah, 0DBh,04Ch,0A2h,04Ah, 0DDh,0F4h,0A3h,04Ah, 002h,005h,0A7h,04Ah
	db	0D3h,000h,0ACh,04Ah, 0DEh,0CDh,0ADh,04Ah, 0DBh,04Ch,0AEh,04Ah, 0DDh,0F4h,0AFh,04Ah
	db	07Fh,03Fh,0A4h,062h, 07Fh,03Fh,0B4h,062h, 07Fh,03Fh,0CFh,062h, 07Fh,03Fh,0E7h,062h
	db	07Fh,03Fh,0F7h,062h, 07Fh,03Fh,007h,063h, 07Fh,03Fh,01Fh,063h, 07Fh,03Fh,0A1h,063h
	db	07Fh,03Fh,0B7h,063h, 07Fh,03Fh,0C9h,063h, 07Fh,03Fh,0DBh,063h, 07Fh,03Fh,0F2h,063h
	db	07Fh,03Fh,00Bh,064h, 07Fh,03Fh,04Eh,067h, 07Fh,03Fh,061h,067h, 0BEh,098h,066h,084h
	db	0BEh,098h,0F2h,084h

FAtetris:
	db	11
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 0DCh,0A2h,078h,0ADh, 0DBh,03Eh,084h,0ADh
	db	0DDh,0FFh,085h,0ADh, 0DCh,0A2h,095h,0ADh, 07Fh,03Fh,0F1h,0ADh, 07Fh,03Fh,00Ah,0AEh
	db	07Fh,03Fh,017h,0AEh, 07Fh,03Fh,047h,0AEh, 07Fh,03Fh,07Dh,0AEh

Flashpoint:
	db	52
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 0C9h,0C3h,010h,030h, 0C9h,020h,011h,030h
	db	0C9h,0F4h,012h,030h, 0C9h,0C3h,018h,030h, 0C9h,04Ch,019h,030h, 0C9h,0F4h,01Ah,030h
	db	020h,014h,000h,031h, 0DBh,000h,01Eh,035h, 0DCh,0D7h,01Fh,035h, 0DBh,000h,02Bh,035h
	db	0DDh,0DFh,02Ch,035h, 0DBh,000h,054h,037h, 0DCh,0D7h,055h,037h, 0DBh,000h,0B8h,053h
	db	0DCh,0D7h,0B9h,053h, 0DBh,000h,0BFh,053h, 0DCh,0D7h,0C0h,053h, 0DBh,000h,0C7h,053h
	db	0DDh,0DFh,0C8h,053h, 0DBh,000h,00Eh,054h, 0DCh,0D7h,00Fh,054h, 0DBh,000h,017h,054h
	db	0DDh,0DFh,018h,054h, 032h,000h,029h,09Bh, 080h,000h,02Ah,09Bh, 0FAh,000h,02Bh,09Bh
	db	07Fh,03Fh,02Eh,09Ch, 07Fh,03Fh,051h,09Ch, 07Fh,03Fh,064h,09Ch, 07Fh,03Fh,074h,09Ch
	db	07Fh,03Fh,097h,09Ch, 07Fh,03Fh,09Fh,09Ch, 0DBh,000h,0B4h,09Ch, 0DCh,0D7h,0B5h,09Ch
	db	0DBh,000h,0B8h,09Ch, 0DCh,0D7h,0B9h,09Ch, 0DBh,000h,0BFh,09Ch, 0DDh,0DFh,0C0h,09Ch
	db	0DBh,000h,0E7h,09Ch, 0DCh,0D7h,0E8h,09Ch, 0DBh,000h,0F0h,09Ch, 0DCh,0D7h,0F1h,09Ch
	db	0DBh,000h,0F8h,09Ch, 0DDh,0DFh,0F9h,09Ch, 0DBh,000h,004h,09Dh, 0DCh,0D7h,005h,09Dh
	db	0DBh,000h,00Bh,09Dh, 0DCh,0D7h,00Ch,09Dh, 0DBh,000h,013h,09Dh, 0DDh,0DFh,014h,09Dh

Flicky:
	db	26
	db	0BEh,098h,09Eh,031h, 07Fh,03Fh,009h,032h, 07Fh,03Fh,00Dh,032h, 07Fh,03Fh,011h,032h
	db	07Fh,03Fh,015h,032h, 0DCh,0A2h,0B2h,057h, 0DBh,03Eh,0B4h,057h, 0DDh,0FFh,0B5h,057h
	db	0DCh,0A2h,0C5h,057h, 0DBh,03Eh,0D2h,057h, 0DDh,0FFh,0D3h,057h, 0DCh,0A2h,0E7h,057h
	db	0DBh,03Eh,0EFh,057h, 0DDh,0FFh,0F0h,057h, 0DCh,0A2h,001h,058h, 0DBh,03Eh,00Eh,058h
	db	0DDh,0FFh,00Fh,058h, 0DCh,0A2h,022h,058h, 0DCh,0A2h,02Eh,058h, 0DCh,0A2h,03Ah,058h
	db	0DCh,0A2h,046h,058h, 0DCh,0A2h,052h,058h, 0DCh,0A2h,064h,058h, 0DCh,0A2h,070h,058h
	db	07Fh,03Fh,07Dh,0A3h, 07Fh,03Fh,090h,0A3h

FlickyR1:
	db	18
	db	0BEh,098h,09Eh,031h, 07Fh,03Fh,093h,032h, 07Fh,03Fh,097h,032h, 07Fh,03Fh,09Bh,032h
	db	07Fh,03Fh,09Fh,032h, 0DCh,0A2h,0ECh,057h, 0DCh,0A2h,0FBh,057h, 0DCh,0A2h,00Fh,058h
	db	0DCh,0A2h,018h,058h, 0DCh,0A2h,02Bh,058h, 0DCh,0A2h,037h,058h, 0DCh,0A2h,043h,058h
	db	0DCh,0A2h,04Fh,058h, 0DCh,0A2h,05Bh,058h, 0DCh,0A2h,06Dh,058h, 0DCh,0A2h,079h,058h
	db	07Fh,03Fh,086h,0A3h, 07Fh,03Fh,099h,0A3h

Flipper:	; Only 1 player supported
	db	28
	db	07Fh,03Fh,00Fh,034h, 07Fh,03Fh,013h,034h, 07Fh,03Fh,017h,034h, 07Fh,03Fh,01Bh,034h
	db	0DCh,0A2h,070h,049h, 0DBh,018h,072h,049h, 0DDh,00Bh,073h,049h, 0DCh,0A2h,083h,049h
	db	0DBh,03Eh,090h,049h, 0DDh,0FFh,091h,049h, 0DCh,0A2h,0A5h,049h, 0DBh,03Eh,0ADh,049h
	db	0DDh,0FFh,0AEh,049h, 0DCh,0A2h,0BFh,049h, 0DBh,03Eh,0CCh,049h, 0DDh,0FFh,0CDh,049h
	db	0DCh,0A2h,0E2h,049h, 0DCh,0A2h,0EEh,049h, 0DCh,0A2h,0FAh,049h, 0DCh,0A2h,00Ch,04Ah
	db	0DBh,03Eh,017h,04Ah, 0DDh,0FFh,018h,04Ah, 07Fh,03Fh,049h,06Ch, 07Fh,03Fh,05Ch,06Ch
	db	07Fh,03Fh,06Fh,06Ch, 07Fh,03Fh,082h,06Ch, 07Fh,03Fh,095h,06Ch, 07Fh,03Fh,0A8h,06Ch

Flipper40:	; Only 1 player supported
	db	28
	db	07Fh,03Fh,00Fh,034h, 07Fh,03Fh,013h,034h, 07Fh,03Fh,017h,034h, 07Fh,03Fh,01Bh,034h
	db	0DCh,0A2h,070h,049h, 0DBh,018h,072h,049h, 0DDh,00Bh,073h,049h, 0DCh,0A2h,083h,049h
	db	0DBh,03Eh,090h,049h, 0DDh,0FFh,091h,049h, 0DCh,0A2h,0A5h,049h, 0DBh,03Eh,0ADh,049h
	db	0DDh,0FFh,0AEh,049h, 0DCh,0A2h,0BFh,049h, 0DBh,03Eh,0CCh,049h, 0DDh,0FFh,0CDh,049h
	db	0DCh,0A2h,0E2h,049h, 0DCh,0A2h,0EEh,049h, 0DCh,0A2h,0FAh,049h, 0DCh,0A2h,00Ch,04Ah
	db	0DBh,03Eh,017h,04Ah, 0DDh,0FFh,018h,04Ah, 07Fh,03Fh,049h,0CCh, 07Fh,03Fh,05Ch,0CCh
	db	07Fh,03Fh,06Fh,0CCh, 07Fh,03Fh,082h,0CCh, 07Fh,03Fh,095h,0CCh, 07Fh,03Fh,0A8h,0CCh

Galaga16:	; 2 players supported
	db	39
	db	0D3h,0CDh,072h,033h, 0DEh,020h,073h,033h, 0DBh,0F4h,074h,033h, 0DCh,012h,075h,033h
	db	012h,013h,076h,033h, 013h,06Fh,077h,033h, 06Fh,0CDh,078h,033h, 0DBh,04Ch,079h,033h
	db	0DDh,0F4h,07Ah,033h, 0D3h,000h,087h,033h, 0DEh,0CDh,088h,033h, 0DBh,020h,089h,033h
	db	0DCh,0F4h,08Ah,033h, 002h,005h,08Eh,033h, 0D3h,000h,093h,033h, 0DEh,0CDh,094h,033h
	db	0DBh,020h,095h,033h, 0DCh,0F4h,096h,033h, 002h,004h,09Bh,033h, 0D3h,0CDh,0A0h,033h
	db	0DEh,04Ch,0A1h,033h, 0DBh,0F4h,0A2h,033h, 0DDh,0E6h,0A3h,033h, 0E6h,008h,0A4h,033h
	db	008h,020h,0A5h,033h, 020h,002h,0A6h,033h, 002h,0CBh,0A7h,033h, 0CBh,0A6h,0A8h,033h
	db	0A6h,02Bh,0A9h,033h, 02Bh,0CDh,0AAh,033h, 0DBh,020h,0ABh,033h, 0DCh,0F4h,0ACh,033h
	db	002h,005h,0B0h,033h, 0D3h,000h,0B5h,033h, 0DEh,0CDh,0B6h,033h, 0DBh,020h,0B7h,033h
	db	0DCh,0F4h,0B8h,033h, 07Fh,03Fh,036h,060h, 07Fh,03Fh,077h,060h

Galaga40:	; 2 players supported
	db	39
	db	0D3h,0CDh,072h,033h, 0DEh,020h,073h,033h, 0DBh,0F4h,074h,033h, 0DCh,012h,075h,033h
	db	012h,013h,076h,033h, 013h,06Fh,077h,033h, 06Fh,0CDh,078h,033h, 0DBh,04Ch,079h,033h
	db	0DDh,0F4h,07Ah,033h, 0D3h,000h,087h,033h, 0DEh,0CDh,088h,033h, 0DBh,020h,089h,033h
	db	0DCh,0F4h,08Ah,033h, 002h,005h,08Eh,033h, 0D3h,000h,093h,033h, 0DEh,0CDh,094h,033h
	db	0DBh,020h,095h,033h, 0DCh,0F4h,096h,033h, 002h,004h,09Bh,033h, 0D3h,0CDh,0A0h,033h
	db	0DEh,04Ch,0A1h,033h, 0DBh,0F4h,0A2h,033h, 0DDh,0E6h,0A3h,033h, 0E6h,008h,0A4h,033h
	db	008h,020h,0A5h,033h, 020h,002h,0A6h,033h, 002h,0CBh,0A7h,033h, 0CBh,0A6h,0A8h,033h
	db	0A6h,02Bh,0A9h,033h, 02Bh,0CDh,0AAh,033h, 0DBh,020h,0ABh,033h, 0DCh,0F4h,0ACh,033h
	db	002h,005h,0B0h,033h, 0D3h,000h,0B5h,033h, 0DEh,0CDh,0B6h,033h, 0DBh,020h,0B7h,033h
	db	0DCh,0F4h,0B8h,033h, 07Fh,03Fh,024h,0C2h, 07Fh,03Fh,065h,0C2h

GirlsGarden:
	db	25
	db	07Fh,03Fh,050h,033h, 07Fh,03Fh,054h,033h, 07Fh,03Fh,058h,033h, 07Fh,03Fh,05Ch,033h
	db	0DCh,0A2h,06Eh,033h, 0DCh,0A2h,07Ah,033h, 0DCh,0A2h,086h,033h, 0DCh,0A2h,092h,033h
	db	0DCh,0A2h,09Eh,033h, 0DCh,0A2h,0AAh,033h, 0DCh,0A2h,0B6h,033h, 0DCh,0A2h,0FAh,05Fh
	db	0DCh,0A2h,004h,060h, 0DCh,0A2h,00Eh,060h, 0EDh,0C3h,019h,0A3h, 0B3h,0FBh,01Ah,0A3h
	db	0C9h,07Fh,01Bh,0A3h, 07Fh,03Fh,003h,0A3h, 07Fh,03Fh,003h,0A3h, 07Fh,03Fh,016h,0A3h
	db	0FFh,0EDh,0FBh,0AFh, 0FFh,0B3h,0FCh,0AFh, 0FFh,00Eh,0FDh,0AFh, 0FFh,07Fh,0FEh,0AFh
	db	0FFh,0C9h,0FFh,0AFh

Golgo13:
	db	28
	db	0BEh,098h,0B8h,030h, 0DCh,0A2h,0B3h,037h, 0DBh,03Eh,0BEh,037h, 0DDh,0FFh,0BFh,037h
	db	0DCh,0A2h,0CCh,037h, 0DBh,03Eh,0D9h,037h, 0DDh,0FFh,0DAh,037h, 0DCh,0A2h,0EEh,037h
	db	0DCh,0A2h,0F7h,037h, 0DBh,03Eh,004h,038h, 0DDh,0FFh,005h,038h, 0DCh,0A2h,017h,038h
	db	0DCh,0A2h,023h,038h, 0DCh,0A2h,02Fh,038h, 0DCh,0A2h,03Bh,038h, 0DCh,0A2h,047h,038h
	db	0DCh,0A2h,059h,038h, 0DCh,0A2h,065h,038h, 0DBh,03Eh,070h,038h, 0DDh,0FFh,071h,038h
	db	0DBh,03Eh,07Ch,038h, 0DDh,0FFh,07Dh,038h, 07Fh,03Fh,0D2h,048h, 07Fh,03Fh,0D6h,048h
	db	07Fh,03Fh,0DAh,048h, 07Fh,03Fh,0DEh,048h, 07Fh,03Fh,000h,083h, 07Fh,03Fh,013h,083h

GPWorld:
	db	19
	db	07Fh,03Fh,093h,031h, 07Fh,03Fh,097h,031h, 07Fh,03Fh,09Bh,031h, 07Fh,03Fh,09Fh,031h
	db	0DCh,0A2h,005h,032h, 0DCh,0A2h,011h,032h, 0DCh,0A2h,01Ah,032h, 0DCh,0A2h,026h,032h
	db	0DCh,0A2h,032h,032h, 0DCh,0A2h,044h,032h, 0DCh,0A2h,050h,032h, 07Fh,03Fh,0FBh,0A2h
	db	07Fh,03Fh,0FFh,0A2h, 07Fh,03Fh,041h,0A8h, 07Fh,03Fh,054h,0A8h, 07Fh,03Fh,067h,0A8h
	db	07Fh,03Fh,07Ah,0A8h, 07Fh,03Fh,08Dh,0A8h, 07Fh,03Fh,0A0h,0A8h

GunSmoke:
	db	9
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 07Fh,03Fh,0C0h,030h, 07Fh,03Fh,0E3h,030h
	db	07Fh,03Fh,0F6h,030h, 07Fh,03Fh,004h,031h, 07Fh,03Fh,027h,031h, 07Fh,03Fh,02Fh,031h
	db	0DCh,0A2h,039h,031h

Guzzler:
	db	10
	db	0BFh,099h,029h,031h, 0DCh,0A2h,0ABh,046h, 0DCh,0A2h,0BFh,046h, 0DCh,0A2h,0CBh,046h
	db	0DCh,0A2h,0D7h,046h, 0DCh,0A2h,0E3h,046h, 0DCh,0A2h,0EFh,046h, 0DCh,0A2h,00Ch,047h
	db	07Fh,03Fh,0A4h,047h, 07Fh,03Fh,0BAh,047h

HangOnII:
	db	28
	db	0BEh,098h,032h,030h, 0BEh,098h,03Eh,030h, 07Fh,03Fh,0CDh,031h, 07Fh,03Fh,0D1h,031h
	db	07Fh,03Fh,0D5h,031h, 07Fh,03Fh,0D9h,031h, 0BEh,098h,00Dh,032h, 0BFh,099h,081h,032h
	db	07Fh,03Fh,0D5h,032h, 07Fh,03Fh,0D9h,032h, 07Fh,03Fh,0DDh,032h, 07Fh,03Fh,0E1h,032h
	db	0DCh,0A2h,0EBh,032h, 0DCh,0A2h,0F4h,032h, 0DCh,0A2h,0FBh,032h, 0DCh,0A2h,008h,033h
	db	0DCh,0A2h,015h,033h, 0DCh,0A2h,029h,033h, 0DCh,0A2h,036h,033h, 07Fh,03Fh,06Eh,07Dh
	db	07Fh,03Fh,008h,07Fh, 07Fh,03Fh,012h,07Fh, 07Fh,03Fh,01Ah,07Fh, 07Fh,03Fh,064h,081h
	db	07Fh,03Fh,005h,082h, 07Fh,03Fh,018h,082h, 07Fh,03Fh,025h,082h, 07Fh,03Fh,029h,082h

Hero:	; 2 players supported
	db	14
	db	0D3h,0CDh,061h,05Eh, 0DEh,04Ch,062h,05Eh, 0DBh,0F4h,063h,05Eh, 0DDh,02Fh,064h,05Eh
	db	02Fh,0E6h,065h,05Eh, 0E6h,00Fh,066h,05Eh, 00Fh,047h,067h,05Eh, 047h,0CDh,068h,05Eh
	db	0DBh,020h,069h,05Eh, 0DCh,0F4h,06Ah,05Eh, 07Fh,03Fh,04Dh,0A7h, 07Fh,03Fh,060h,0A7h
	db	07Fh,03Fh,06Dh,0A7h, 07Fh,03Fh,071h,0A7h

;HongKilDong:	; (removed because Out of Memory)
;	db	33
;	db	0FFh,0C3h,010h,030h, 0FFh,020h,011h,030h, 0FFh,0F4h,012h,030h, 0FFh,0C3h,018h,030h
;	db	0FFh,04Ch,019h,030h, 0FFh,0F4h,01Ah,030h, 07Fh,03Fh,008h,032h, 07Fh,03Fh,01Fh,032h
;	db	07Fh,03Fh,042h,032h, 07Fh,03Fh,055h,032h, 07Fh,03Fh,063h,032h, 07Fh,03Fh,08Ah,032h
;	db	0DBh,000h,095h,032h, 0DCh,0D7h,096h,032h, 0DBh,000h,09Ah,032h, 0DDh,0DFh,09Bh,032h
;	db	0DBh,000h,0A3h,032h, 0DCh,0D7h,0A4h,032h, 0DBh,000h,0D6h,032h, 0DDh,0DFh,0D7h,032h
;	db	0DBh,000h,0E2h,032h, 0DCh,0D7h,0E3h,032h, 0DBh,000h,0EEh,032h, 0DCh,0D7h,0EFh,032h
;	db	0DBh,000h,0FAh,032h, 0DDh,0DFh,0FBh,032h, 0DBh,000h,00Eh,033h, 0DCh,0D7h,00Fh,033h
;	db	0BEh,098h,042h,039h, 0DBh,000h,042h,062h, 0DCh,0D7h,043h,062h, 0BEh,098h,0D6h,062h
;	db	0BEh,098h,063h,063h

HustleChumy:
	db	11
	db	0DCh,0A2h,0C6h,032h, 0BEh,098h,031h,033h, 0BEh,098h,040h,033h, 0BEh,098h,0BDh,033h
	db	0BEh,098h,06Ch,051h, 07Fh,03Fh,0D3h,064h, 07Fh,03Fh,0D7h,064h, 07Fh,03Fh,0E0h,064h
	db	07Fh,03Fh,0EAh,064h, 07Fh,03Fh,0EDh,064h, 07Fh,03Fh,0F1h,065h

HyperSport:
	db	33
	db	07Fh,03Fh,07Fh,030h, 07Fh,03Fh,083h,030h, 07Fh,03Fh,087h,030h, 07Fh,03Fh,08Bh,030h
	db	0BEh,098h,03Fh,032h, 07Fh,03Fh,0C3h,060h, 07Fh,03Fh,0CDh,060h, 07Fh,03Fh,0D1h,060h
	db	0DCh,0A2h,037h,065h, 0DBh,03Eh,03Dh,065h, 0DDh,0FFh,03Eh,065h, 0DCh,0A2h,065h,065h
	db	0DBh,03Eh,06Fh,065h, 0DDh,0FFh,070h,065h, 0DCh,0A2h,0A5h,065h, 0DBh,03Eh,0B4h,065h
	db	0DDh,0FFh,0B5h,065h, 0DBh,03Eh,0C4h,065h, 0DDh,0FFh,0C5h,065h, 0DCh,0A2h,0D9h,065h
	db	0DCh,0A2h,0E9h,065h, 0DCh,0A2h,011h,066h, 0DBh,03Eh,01Ah,066h, 0DDh,0FFh,01Bh,066h
	db	0DBh,03Eh,035h,066h, 0DDh,0FFh,036h,066h, 0DBh,03Eh,043h,066h, 0DDh,0FFh,044h,066h
	db	0DCh,0A2h,054h,066h, 0DCh,0A2h,062h,066h, 07Fh,03Fh,0CFh,07Ch, 07Fh,03Fh,0A3h,080h
	db	07Fh,03Fh,0B6h,080h

JamesBond007v26:	; Only 1 player supported
	db	51
	db	0BEh,098h,045h,030h, 0BEh,098h,05Bh,030h, 0BEh,098h,083h,030h, 07Fh,03Fh,00Dh,04Ah
	db	07Fh,03Fh,040h,04Ah, 07Fh,03Fh,04Dh,04Ah, 07Fh,03Fh,05Dh,04Ah, 0BEh,098h,09Dh,0C0h
	db	0DBh,03Eh,0CEh,0C0h, 0DDh,0FFh,0CFh,0C0h, 0DCh,0A2h,0DDh,0C0h, 0DBh,03Eh,0F4h,0C0h
	db	0DDh,0FFh,0F5h,0C0h, 0DBh,03Eh,000h,0C1h, 0DDh,0FFh,001h,0C1h, 0DCh,0A2h,00Dh,0C1h
	db	0DCh,0A2h,019h,0C1h, 0BEh,098h,058h,0C6h, 0BEh,098h,001h,0CAh, 0BEh,098h,07Eh,0CAh
	db	0BEh,098h,0CBh,0CAh, 07Fh,03Fh,0D9h,0CAh, 07Fh,03Fh,0DDh,0CAh, 07Fh,03Fh,0E1h,0CAh
	db	07Fh,03Fh,0E5h,0CAh, 07Fh,03Fh,0EEh,0CAh, 07Fh,03Fh,0FBh,0CAh, 07Fh,03Fh,00Dh,0CBh
	db	07Fh,03Fh,01Eh,0CBh, 07Fh,03Fh,056h,0CBh, 0DCh,0A2h,0ACh,0CBh, 0DBh,03Eh,0BEh,0CBh
	db	0DDh,0FFh,0BFh,0CBh, 0DCh,0A2h,0E2h,0CBh, 0DCh,0A2h,0EEh,0CBh, 0DBh,03Eh,0FEh,0CBh
	db	0DDh,0FFh,0FFh,0CBh, 0DBh,03Eh,00Ah,0CCh, 0DDh,0FFh,00Bh,0CCh, 0DCh,0A2h,02Bh,0CCh
	db	0DCh,0A2h,033h,0CCh, 0DBh,03Eh,037h,0CCh, 0DDh,0FFh,038h,0CCh, 0DCh,0A2h,04Eh,0CCh
	db	0DCh,0A2h,05Ch,0CCh, 0DCh,0A2h,068h,0CCh, 0DCh,0A2h,076h,0CCh, 0DCh,0A2h,083h,0CCh
	db	0DCh,0A2h,091h,0CCh, 0DCh,0A2h,09Dh,0CCh, 0DCh,0A2h,0ABh,0CCh

JamesBond007v27:	; Only 1 player supported
	db	52
	db	0BEh,098h,045h,030h, 0BEh,098h,05Bh,030h, 0BEh,098h,083h,030h, 07Fh,03Fh,00Dh,04Ah
	db	07Fh,03Fh,040h,04Ah, 07Fh,03Fh,04Dh,04Ah, 07Fh,03Fh,05Dh,04Ah, 0BEh,098h,09Dh,060h
	db	0DBh,03Eh,0D8h,060h, 0DDh,0FFh,0D9h,060h, 0DCh,0A2h,0E5h,060h, 0DBh,03Eh,0FAh,060h
	db	0DDh,0FFh,0FBh,060h, 0DBh,03Eh,006h,061h, 0DDh,0FFh,007h,061h, 0DCh,0A2h,013h,061h
	db	0DCh,0A2h,01Fh,061h, 0BEh,098h,058h,066h, 0BEh,098h,001h,06Ah, 0BEh,098h,07Eh,06Ah
	db	0BEh,098h,0CBh,06Ah, 07Fh,03Fh,0D9h,06Ah, 07Fh,03Fh,0DDh,06Ah, 07Fh,03Fh,0E1h,06Ah
	db	07Fh,03Fh,0E5h,06Ah, 07Fh,03Fh,0EEh,06Ah, 07Fh,03Fh,0FBh,06Ah, 07Fh,03Fh,00Dh,06Bh
	db	07Fh,03Fh,01Eh,06Bh, 07Fh,03Fh,056h,06Bh, 0BEh,098h,0B2h,06Bh, 0DCh,0A2h,0FEh,06Ch
	db	0DBh,03Eh,010h,06Dh, 0DDh,0FFh,011h,06Dh, 0DCh,0A2h,037h,06Dh, 0DCh,0A2h,046h,06Dh
	db	0DBh,03Eh,059h,06Dh, 0DDh,0FFh,05Ah,06Dh, 0DBh,03Eh,068h,06Dh, 0DDh,0FFh,069h,06Dh
	db	0DCh,0A2h,08Ch,06Dh, 0DCh,0A2h,094h,06Dh, 0DBh,03Eh,098h,06Dh, 0DDh,0FFh,099h,06Dh
	db	0DCh,0A2h,0B2h,06Dh, 0DCh,0A2h,0C3h,06Dh, 0DCh,0A2h,0D2h,06Dh, 0DCh,0A2h,0E3h,06Dh
	db	0DCh,0A2h,0F3h,06Dh, 0DCh,0A2h,004h,06Eh, 0DCh,0A2h,013h,06Eh, 0DCh,0A2h,024h,06Eh

KingValley:
	db	26
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 0DCh,0A2h,0BEh,031h, 0DCh,0A2h,0C9h,031h
	db	07Fh,03Fh,0F9h,031h, 07Fh,03Fh,0FDh,031h, 07Fh,03Fh,016h,032h, 07Fh,03Fh,01Fh,032h
	db	07Fh,03Fh,027h,032h, 07Fh,03Fh,02Fh,032h, 07Fh,03Fh,041h,032h, 07Fh,03Fh,063h,032h
	db	07Fh,03Fh,013h,033h, 07Fh,03Fh,01Ch,033h, 07Fh,03Fh,027h,033h, 07Fh,03Fh,060h,033h
	db	07Fh,03Fh,099h,033h, 07Fh,03Fh,09Eh,033h, 07Fh,03Fh,0C7h,033h, 07Fh,03Fh,0DCh,033h
	db	07Fh,03Fh,0F0h,033h, 07Fh,03Fh,0FAh,033h, 0DCh,0A2h,00Dh,034h, 07Fh,03Fh,048h,034h
	db	0DCh,0A2h,0A8h,034h, 07Fh,03Fh,01Fh,036h

LodeRunner:
	db	92
	db	0BFh,099h,023h,030h, 0BFh,099h,085h,030h, 0BFh,099h,02Ah,031h, 0DBh,03Eh,069h,041h
	db	0DDh,0FFh,06Ah,041h, 0DCh,0A2h,073h,041h, 0DBh,03Eh,089h,041h, 0DDh,0FFh,08Ah,041h
	db	0DCh,0A2h,093h,041h, 0DBh,03Eh,0A9h,041h, 0DDh,0FFh,0AAh,041h, 0DCh,0A2h,0B3h,041h
	db	0DBh,03Eh,0CBh,041h, 0DDh,0FFh,0CCh,041h, 0DCh,0A2h,0D5h,041h, 0DBh,03Eh,0F4h,041h
	db	0DDh,0FFh,0F5h,041h, 0DCh,0A2h,0FEh,041h, 00Eh,012h,025h,04Fh, 0DCh,0A2h,027h,04Fh
	db	04Fh,0F6h,028h,04Fh, 047h,0C0h,029h,04Fh, 0DBh,04Fh,02Ah,04Fh, 0DDh,047h,02Bh,04Fh
	db	0CBh,03Eh,02Ch,04Fh, 011h,0FFh,02Dh,04Fh, 017h,0CBh,02Eh,04Fh, 0CBh,011h,02Fh,04Fh
	db	011h,017h,030h,04Fh, 017h,0CBh,031h,04Fh, 0A0h,011h,032h,04Fh, 0C9h,017h,033h,04Fh
	db	03Eh,0A0h,034h,04Fh, 007h,0C9h,035h,04Fh, 0DCh,0A2h,039h,04Fh, 04Fh,0F6h,03Ah,04Fh
	db	03Eh,0C0h,03Bh,04Fh, 002h,04Fh,03Ch,04Fh, 0DCh,0A2h,040h,04Fh, 0DCh,0A2h,04Ch,04Fh
	db	0DCh,0A2h,058h,04Fh, 0DCh,0A2h,064h,04Fh, 0DCh,0A2h,070h,04Fh, 020h,018h,079h,04Fh
	db	0BEh,098h,0F3h,050h, 0BEh,098h,008h,051h, 07Fh,03Fh,04Ah,051h, 07Fh,03Fh,04Eh,051h
	db	07Fh,03Fh,052h,051h, 07Fh,03Fh,056h,051h, 07Fh,03Fh,05Dh,051h, 07Fh,03Fh,061h,051h
	db	07Fh,03Fh,065h,051h, 07Fh,03Fh,069h,051h, 0DBh,03Eh,071h,05Dh, 0DDh,0FFh,072h,05Dh
	db	0DCh,0A2h,07Ch,05Dh, 020h,018h,08Bh,05Dh, 0DCh,0A2h,094h,05Dh, 0DCh,0A2h,0A0h,05Dh
	db	020h,018h,0A3h,05Dh, 0DBh,03Eh,0ABh,05Dh, 0DDh,0FFh,0ACh,05Dh, 0DBh,03Eh,0D0h,05Dh
	db	0DDh,0FFh,0D1h,05Dh, 0DCh,0A2h,0DDh,05Dh, 0DCh,0A2h,0EFh,05Dh, 0DBh,03Eh,0FAh,05Dh
	db	0DDh,0FFh,0FBh,05Dh, 0DCh,0A2h,007h,05Eh, 0DCh,0A2h,023h,05Eh, 0DCh,0A2h,02Fh,05Eh
	db	0DCh,0A2h,03Bh,05Eh, 0DCh,0A2h,047h,05Eh, 0DCh,0A2h,053h,05Eh, 0DCh,0A2h,05Fh,05Eh
	db	0DCh,0A2h,06Bh,05Eh, 0DBh,03Eh,076h,05Eh, 0DDh,0FFh,077h,05Eh, 0DBh,03Eh,082h,05Eh
	db	0DDh,0FFh,083h,05Eh, 0DBh,03Eh,08Eh,05Eh, 0DDh,0FFh,08Fh,05Eh, 0DBh,03Eh,0CFh,066h
	db	0DDh,0FFh,0D0h,066h, 07Fh,03Fh,0F5h,068h, 07Fh,03Fh,080h,06Bh, 07Fh,03Fh,093h,06Bh
	db	07Fh,03Fh,0A6h,06Bh, 07Fh,03Fh,0B9h,06Bh, 07Fh,03Fh,0CCh,06Bh, 07Fh,03Fh,0DFh,06Bh

Mahjong:
	db	15
	db	07Fh,03Fh,0F2h,030h, 07Fh,03Fh,0F6h,030h, 07Fh,03Fh,0FEh,030h, 07Fh,03Fh,009h,031h
	db	07Fh,03Fh,065h,031h, 07Fh,03Fh,069h,031h, 07Fh,03Fh,06Dh,031h, 07Fh,03Fh,071h,031h
	db	0BEh,098h,084h,033h, 0DCh,0A2h,0CAh,07Bh, 0DBh,03Eh,0D4h,07Bh, 0DDh,0FFh,0D5h,07Bh
	db	0D3h,03Eh,0DAh,07Bh, 0DBh,03Eh,0DCh,07Bh, 0DDh,0FFh,0DDh,07Bh

MicroXevious:
	db	17
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 0DCh,0A2h,0E2h,034h, 0DCh,0A2h,0F5h,046h
	db	0DBh,03Eh,007h,047h, 0DDh,0FFh,008h,047h, 0DBh,03Eh,023h,047h, 0DDh,0FFh,024h,047h
	db	0DCh,0A2h,02Ch,047h, 0DBh,03Eh,033h,047h, 0DDh,0FFh,034h,047h, 0DCh,0A2h,03Ch,047h
	db	07Fh,03Fh,0D2h,047h, 07Fh,03Fh,0F5h,047h, 07Fh,03Fh,008h,048h, 07Fh,03Fh,016h,048h
	db	07Fh,03Fh,04Dh,048h

MonacoGP:
	db	42
	db	07Fh,03Fh,084h,030h, 07Fh,03Fh,088h,030h, 07Fh,03Fh,08Ch,030h, 07Fh,03Fh,090h,030h
	db	07Fh,03Fh,0F7h,032h, 07Fh,03Fh,0FBh,032h, 07Fh,03Fh,0FFh,032h, 07Fh,03Fh,003h,033h
	db	0BEh,098h,02Bh,04Bh, 07Fh,03Fh,040h,052h, 07Fh,03Fh,044h,052h, 07Fh,03Fh,048h,052h
	db	07Fh,03Fh,04Ch,052h, 0DCh,0A2h,008h,053h, 0DCh,0A2h,01Ch,053h, 0DCh,0A2h,031h,053h
	db	0DCh,0A2h,03Dh,053h, 0DCh,0A2h,049h,053h, 0DCh,0A2h,055h,053h, 0DCh,0A2h,061h,053h
	db	0DCh,0A2h,073h,053h, 0DCh,0A2h,07Fh,053h, 07Fh,03Fh,031h,057h, 07Fh,03Fh,035h,057h
	db	07Fh,03Fh,039h,057h, 07Fh,03Fh,03Dh,057h, 07Fh,03Fh,057h,084h, 0DCh,0A2h,0B2h,09Bh
	db	0DBh,03Eh,0C3h,09Bh, 0DDh,0FFh,0C4h,09Bh, 07Fh,03Fh,0C8h,0A0h, 07Fh,03Fh,0DBh,0A0h
	db	07Fh,03Fh,0EEh,0A0h, 07Fh,03Fh,001h,0A1h, 07Fh,03Fh,014h,0A1h, 07Fh,03Fh,027h,0A1h
	db	07Fh,03Fh,039h,0B0h, 07Fh,03Fh,04Ch,0B0h, 07Fh,03Fh,05Fh,0B0h, 07Fh,03Fh,072h,0B0h
	db	07Fh,03Fh,085h,0B0h, 07Fh,03Fh,098h,0B0h

MonacoGPr1:
	db	32
	db	07Fh,03Fh,084h,030h, 07Fh,03Fh,088h,030h, 07Fh,03Fh,08Ch,030h, 07Fh,03Fh,090h,030h
	db	07Fh,03Fh,026h,033h, 07Fh,03Fh,02Ah,033h, 07Fh,03Fh,02Eh,033h, 07Fh,03Fh,032h,033h
	db	0BEh,098h,05Ah,04Bh, 07Fh,03Fh,0E6h,051h, 07Fh,03Fh,0EAh,051h, 07Fh,03Fh,0EEh,051h
	db	07Fh,03Fh,0F2h,051h, 0DCh,0A2h,0AEh,052h, 0DCh,0A2h,0C2h,052h, 0DCh,0A2h,0D7h,052h
	db	0DCh,0A2h,0E3h,052h, 0DCh,0A2h,0EFh,052h, 0DCh,0A2h,0FBh,052h, 0DCh,0A2h,007h,053h
	db	0DCh,0A2h,019h,053h, 0DCh,0A2h,025h,053h, 07Fh,03Fh,0D7h,056h, 07Fh,03Fh,0DBh,056h
	db	07Fh,03Fh,0DFh,056h, 07Fh,03Fh,0E3h,056h, 07Fh,03Fh,06Eh,085h, 07Fh,03Fh,081h,085h
	db	07Fh,03Fh,094h,085h, 07Fh,03Fh,0A7h,085h, 07Fh,03Fh,0BAh,085h, 07Fh,03Fh,0CDh,085h

MonacoGPr2:
	db	36
	db	07Fh,03Fh,084h,030h, 07Fh,03Fh,088h,030h, 07Fh,03Fh,08Ch,030h, 07Fh,03Fh,090h,030h
	db	07Fh,03Fh,026h,033h, 07Fh,03Fh,02Ah,033h, 07Fh,03Fh,02Eh,033h, 07Fh,03Fh,032h,033h
	db	0BEh,098h,05Ah,04Bh, 07Fh,03Fh,0E6h,051h, 07Fh,03Fh,0EAh,051h, 07Fh,03Fh,0EEh,051h
	db	07Fh,03Fh,0F2h,051h, 0DCh,0A2h,0C2h,052h, 0DCh,0A2h,0D7h,052h, 0DCh,0A2h,0E3h,052h
	db	0DCh,0A2h,0EFh,052h, 0DCh,0A2h,0FBh,052h, 0DCh,0A2h,007h,053h, 0DCh,0A2h,019h,053h
	db	0DCh,0A2h,025h,053h, 07Fh,03Fh,0D7h,056h, 07Fh,03Fh,0DBh,056h, 07Fh,03Fh,0DFh,056h
	db	07Fh,03Fh,0E3h,056h, 07Fh,03Fh,06Eh,085h, 07Fh,03Fh,081h,085h, 07Fh,03Fh,094h,085h
	db	07Fh,03Fh,0A7h,085h, 07Fh,03Fh,0BAh,085h, 07Fh,03Fh,0CDh,085h, 0DCh,0A2h,081h,0AFh
	db	000h,0F6h,082h,0AFh, 000h,0C0h,083h,0AFh, 0DBh,03Eh,086h,0AFh, 0DDh,0FFh,087h,0AFh

NewBoggleBoggle2:	; 2 players supported
	db	28
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 028h,0C3h,008h,030h, 043h,020h,009h,030h
	db	029h,0F4h,00Ah,030h, 043h,0C3h,010h,030h, 059h,04Ch,011h,030h, 05Fh,0F4h,012h,030h
	db	0FBh,000h,052h,030h, 0DBh,000h,074h,030h, 0DCh,0CFh,075h,030h, 0DBh,000h,087h,030h
	db	0DDh,0D7h,088h,030h, 0DBh,000h,0A3h,030h, 0DDh,0D7h,0A4h,030h, 0DBh,0FBh,0ABh,030h
	db	0DCh,0CFh,0ACh,030h, 0DBh,000h,0B3h,030h, 0DDh,0D7h,0B4h,030h, 0DBh,000h,0BBh,030h
	db	0DCh,0CFh,0BCh,030h, 07Fh,03Fh,04Bh,031h, 07Fh,03Fh,06Fh,031h, 07Fh,03Fh,082h,031h
	db	07Fh,03Fh,090h,031h, 07Fh,03Fh,0C7h,031h, 0DBh,000h,07Dh,033h, 0DCh,0CFh,07Eh,033h

NinjaPrincess:
	db	74
	db	0D3h,0CDh,040h,048h, 0DEh,020h,041h,048h, 0DBh,0F4h,042h,048h, 0DCh,02Fh,043h,048h
	db	02Fh,05Fh,044h,048h, 05Fh,0E6h,045h,048h, 0E6h,03Fh,046h,048h, 03Fh,057h,047h,048h
	db	057h,07Bh,048h,048h, 07Bh,0E6h,049h,048h, 0E6h,0C0h,04Ah,048h, 0C0h,06Fh,04Bh,048h
	db	06Fh,0CDh,04Ch,048h, 0DBh,04Ch,04Dh,048h, 0DDh,0F4h,04Eh,048h, 0D3h,000h,060h,048h
	db	0DEh,0CDh,061h,048h, 0DBh,020h,062h,048h, 0DCh,0F4h,063h,048h, 0D3h,000h,072h,048h
	db	0DEh,0CDh,073h,048h, 0DBh,020h,074h,048h, 0DCh,0F4h,075h,048h, 0D3h,000h,084h,048h
	db	0DEh,0CDh,085h,048h, 0DBh,020h,086h,048h, 0DCh,0F4h,087h,048h, 0D3h,000h,096h,048h
	db	0DEh,0CDh,097h,048h, 0DBh,020h,098h,048h, 0DCh,0F4h,099h,048h, 0D3h,0CDh,0A2h,048h
	db	0DEh,020h,0A3h,048h, 0DBh,0F4h,0A4h,048h, 0DCh,0CBh,0A5h,048h, 0CBh,06Fh,0A6h,048h
	db	06Fh,020h,0A7h,048h, 020h,002h,0A8h,048h, 002h,0CBh,0A9h,048h, 0CBh,0D5h,0AAh,048h
	db	0D5h,0CDh,0ABh,048h, 0DBh,04Ch,0ACh,048h, 0DDh,0F4h,0ADh,048h, 0D3h,0CDh,0B6h,048h
	db	0DEh,020h,0B7h,048h, 0DBh,0F4h,0B8h,048h, 0DCh,0CBh,0B9h,048h, 0CBh,06Fh,0BAh,048h
	db	06Fh,020h,0BBh,048h, 020h,002h,0BCh,048h, 002h,0CBh,0BDh,048h, 0CBh,0DDh,0BEh,048h
	db	0DDh,0CBh,0BFh,048h, 0CBh,077h,0C0h,048h, 077h,020h,0C1h,048h, 020h,002h,0C2h,048h
	db	002h,0CBh,0C3h,048h, 0CBh,0C5h,0C4h,048h, 0C5h,0CDh,0C5h,048h, 0DBh,04Ch,0C6h,048h
	db	0DDh,0F4h,0C7h,048h, 07Fh,03Fh,0DEh,070h, 07Fh,03Fh,0A1h,074h, 07Fh,03Fh,0DCh,074h
	db	07Fh,03Fh,039h,075h, 07Fh,03Fh,051h,075h, 07Fh,03Fh,061h,075h, 07Fh,03Fh,079h,075h
	db	07Fh,03Fh,08Bh,075h, 07Fh,03Fh,0ADh,075h, 07Fh,03Fh,0D4h,075h, 07Fh,03Fh,0DDh,075h
	db	07Fh,03Fh,0E7h,075h, 07Fh,03Fh,0F1h,075h

Nsub:
	db	14
	db	07Fh,03Fh,086h,030h, 07Fh,03Fh,08Ah,030h, 07Fh,03Fh,08Eh,030h, 07Fh,03Fh,092h,030h
	db	07Fh,03Fh,089h,033h, 0DCh,0A2h,0A8h,05Fh, 0DBh,03Eh,0B9h,05Fh, 0DDh,0FFh,0BAh,05Fh
	db	07Fh,03Fh,0D0h,064h, 07Fh,03Fh,0E3h,064h, 07Fh,03Fh,0F6h,064h, 07Fh,03Fh,009h,065h
	db	07Fh,03Fh,01Ch,065h, 07Fh,03Fh,02Fh,065h

OkamotoAyakoGolf:
	db	64
	db	07Fh,03Fh,06Ch,030h, 07Fh,03Fh,070h,030h, 07Fh,03Fh,074h,030h, 07Fh,03Fh,078h,030h
	db	0BFh,099h,0E1h,033h, 0BFh,099h,0F3h,033h, 0D3h,000h,0FEh,034h, 0DEh,0CDh,0FFh,034h
	db	0DBh,020h,000h,035h, 0DCh,0F4h,001h,035h, 0D3h,000h,00Ah,035h, 0DEh,0CDh,00Bh,035h
	db	0DBh,020h,00Ch,035h, 0DCh,0F4h,00Dh,035h, 0D3h,000h,016h,035h, 0DEh,0CDh,017h,035h
	db	0DBh,020h,018h,035h, 0DCh,0F4h,019h,035h, 0D3h,000h,022h,035h, 0DEh,0CDh,023h,035h
	db	0DBh,020h,024h,035h, 0DCh,0F4h,025h,035h, 0D3h,000h,02Eh,035h, 0DEh,0CDh,02Fh,035h
	db	0DBh,020h,030h,035h, 0DCh,0F4h,031h,035h, 0D3h,000h,047h,035h, 0DEh,0CDh,048h,035h
	db	0DBh,04Ch,049h,035h, 0DDh,0F4h,04Ah,035h, 0D3h,000h,053h,035h, 0DEh,0CDh,054h,035h
	db	0DBh,04Ch,055h,035h, 0DDh,0F4h,056h,035h, 0D3h,000h,05Fh,035h, 0DEh,0CDh,060h,035h
	db	0DBh,020h,061h,035h, 0DCh,0F4h,062h,035h, 0D3h,000h,06Bh,035h, 0DEh,0CDh,06Ch,035h
	db	0DBh,020h,06Dh,035h, 0DCh,0F4h,06Eh,035h, 0D3h,000h,077h,035h, 0DEh,0CDh,078h,035h
	db	0DBh,020h,079h,035h, 0DCh,0F4h,07Ah,035h, 0D3h,000h,083h,035h, 0DEh,0CDh,084h,035h
	db	0DBh,020h,085h,035h, 0DCh,0F4h,086h,035h, 0D3h,000h,094h,035h, 0DEh,0CDh,095h,035h
	db	0DBh,020h,096h,035h, 0DCh,0F4h,097h,035h, 0D3h,000h,0A5h,035h, 0DEh,0CDh,0A6h,035h
	db	0DBh,04Ch,0A7h,035h, 0DDh,0F4h,0A8h,035h, 0D3h,000h,0B7h,035h, 0DEh,0CDh,0B8h,035h
	db	0DBh,020h,0B9h,035h, 0DCh,0F4h,0BAh,035h, 0BFh,099h,005h,04Fh, 07Fh,03Fh,0F7h,0AAh

OkamotoAyakoGolfR1:
	db	64
	db	07Fh,03Fh,06Ch,030h, 07Fh,03Fh,070h,030h, 07Fh,03Fh,074h,030h, 07Fh,03Fh,078h,030h
	db	0BFh,099h,0E1h,033h, 0BFh,099h,0F3h,033h, 0D3h,000h,0FEh,034h, 0DEh,0CDh,0FFh,034h
	db	0DBh,020h,000h,035h, 0DCh,0F4h,001h,035h, 0D3h,000h,00Ah,035h, 0DEh,0CDh,00Bh,035h
	db	0DBh,020h,00Ch,035h, 0DCh,0F4h,00Dh,035h, 0D3h,000h,016h,035h, 0DEh,0CDh,017h,035h
	db	0DBh,020h,018h,035h, 0DCh,0F4h,019h,035h, 0D3h,000h,022h,035h, 0DEh,0CDh,023h,035h
	db	0DBh,020h,024h,035h, 0DCh,0F4h,025h,035h, 0D3h,000h,02Eh,035h, 0DEh,0CDh,02Fh,035h
	db	0DBh,020h,030h,035h, 0DCh,0F4h,031h,035h, 0D3h,000h,047h,035h, 0DEh,0CDh,048h,035h
	db	0DBh,04Ch,049h,035h, 0DDh,0F4h,04Ah,035h, 0D3h,000h,053h,035h, 0DEh,0CDh,054h,035h
	db	0DBh,04Ch,055h,035h, 0DDh,0F4h,056h,035h, 0D3h,000h,05Fh,035h, 0DEh,0CDh,060h,035h
	db	0DBh,020h,061h,035h, 0DCh,0F4h,062h,035h, 0D3h,000h,06Bh,035h, 0DEh,0CDh,06Ch,035h
	db	0DBh,020h,06Dh,035h, 0DCh,0F4h,06Eh,035h, 0D3h,000h,077h,035h, 0DEh,0CDh,078h,035h
	db	0DBh,020h,079h,035h, 0DCh,0F4h,07Ah,035h, 0D3h,000h,083h,035h, 0DEh,0CDh,084h,035h
	db	0DBh,020h,085h,035h, 0DCh,0F4h,086h,035h, 0D3h,000h,094h,035h, 0DEh,0CDh,095h,035h
	db	0DBh,020h,096h,035h, 0DCh,0F4h,097h,035h, 0D3h,000h,0A5h,035h, 0DEh,0CDh,0A6h,035h
	db	0DBh,04Ch,0A7h,035h, 0DDh,0F4h,0A8h,035h, 0D3h,000h,0B7h,035h, 0DEh,0CDh,0B8h,035h
	db	0DBh,020h,0B9h,035h, 0DCh,0F4h,0BAh,035h, 0BFh,099h,022h,04Fh, 07Fh,03Fh,0F7h,0AAh

Orguss:
	db	31
	db	07Fh,03Fh,09Fh,035h, 07Fh,03Fh,0A3h,035h, 07Fh,03Fh,0A7h,035h, 07Fh,03Fh,0ABh,035h
	db	0DCh,0A2h,08Ch,037h, 0DBh,03Eh,097h,037h, 0DDh,0FFh,098h,037h, 0DCh,0A2h,0A5h,037h
	db	0DBh,03Eh,0B2h,037h, 0DDh,0FFh,0B3h,037h, 0DCh,0A2h,0C7h,037h, 0DBh,03Eh,0D2h,037h
	db	0DDh,0FFh,0D3h,037h, 0DCh,0A2h,0E4h,037h, 0DBh,03Eh,0F1h,037h, 0DDh,0FFh,0F2h,037h
	db	0DCh,0A2h,004h,038h, 0DCh,0A2h,010h,038h, 0DCh,0A2h,01Ch,038h, 0DCh,0A2h,028h,038h
	db	0DCh,0A2h,034h,038h, 0DCh,0A2h,046h,038h, 0DCh,0A2h,052h,038h, 0DBh,03Eh,05Dh,038h
	db	0DDh,0FFh,05Eh,038h, 0DBh,03Eh,069h,038h, 0DDh,0FFh,06Ah,038h, 07Fh,03Fh,09Bh,0A3h
	db	07Fh,03Fh,0AEh,0A3h, 07Fh,03Fh,0BCh,0A3h, 07Fh,03Fh,0C6h,0A3h

Othello:	; 2 players supported
	db	71
	db	0FFh,0C3h,008h,030h, 0FFh,020h,009h,030h, 0FFh,0F4h,00Ah,030h, 07Fh,03Fh,04Dh,031h
	db	07Fh,03Fh,0C6h,03Dh, 07Fh,03Fh,0CAh,03Dh, 07Fh,03Fh,0CEh,03Dh, 07Fh,03Fh,0E1h,03Eh
	db	07Fh,03Fh,0E5h,03Eh, 07Fh,03Fh,0E9h,03Eh, 07Fh,03Fh,003h,03fh, 07Fh,03Fh,007h,03fh
	db	07Fh,03Fh,012h,03fh, 07Fh,03Fh,016h,03fh, 07Fh,03Fh,020h,03fh, 07Fh,03Fh,025h,03fh
	db	07Fh,03Fh,002h,042h, 07Fh,03Fh,005h,042h, 07Fh,03Fh,009h,042h, 03Ch,03Fh,0D1h,06Ch
	db	0DBh,0CFh,08Eh,07Ch, 0DCh,02Fh,08Fh,07Ch, 02Fh,047h,090h,07Ch, 047h,0E6h,091h,07Ch
	db	0E6h,03Fh,092h,07Ch, 03Fh,032h,093h,07Ch, 032h,0A1h,094h,07Ch, 0A1h,081h,095h,07Ch
	db	081h,0CDh,096h,07Ch, 0DBh,04Ch,097h,07Ch, 0DDh,0F4h,098h,07Ch, 0D3h,000h,0B5h,07Ch
	db	0DEh,0CDh,0B6h,07Ch, 0DBh,020h,0B7h,07Ch, 0DCh,0F4h,0B8h,07Ch, 0D3h,000h,0C1h,07Ch
	db	0DEh,0CDh,0C2h,07Ch, 0DBh,020h,0C3h,07Ch, 0DCh,0F4h,0C4h,07Ch, 0D3h,000h,0CDh,07Ch
	db	0DEh,0CDh,0CEh,07Ch, 0DBh,020h,0CFh,07Ch, 0DCh,0F4h,0D0h,07Ch, 0D3h,000h,0D9h,07Ch
	db	0DEh,0CDh,0DAh,07Ch, 0DBh,020h,0DBh,07Ch, 0DCh,0F4h,0DCh,07Ch, 0D3h,000h,0E5h,07Ch
	db	0DEh,0CDh,0E6h,07Ch, 0DBh,020h,0E7h,07Ch, 0DCh,0F4h,0E8h,07Ch, 0D3h,000h,0FEh,07Ch
	db	0DEh,0CDh,0FFh,07Ch, 0DBh,04Ch,000h,07Dh, 0DDh,0F4h,001h,07Dh, 0D3h,000h,00Ah,07Dh
	db	0DEh,0CDh,00Bh,07Dh, 0DBh,04Ch,00Ch,07Dh, 0DDh,0F4h,00Dh,07Dh, 0D3h,000h,016h,07Dh
	db	0DEh,0CDh,017h,07Dh, 0DBh,020h,018h,07Dh, 0DCh,0F4h,019h,07Dh, 0D3h,000h,022h,07Dh
	db	0DEh,0CDh,023h,07Dh, 0DBh,020h,024h,07Dh, 0DCh,0F4h,025h,07Dh, 0D3h,000h,02Eh,07Dh
	db	0DEh,0CDh,02Fh,07Dh, 0DBh,020h,030h,07Dh, 0DCh,0F4h,031h,07Dh

Pacar:
	db	15
	db	0DCh,0A2h,0DCh,03Bh, 07Fh,03Fh,0CFh,03Fh, 07Fh,03Fh,0D3h,03Fh, 07Fh,03Fh,0D7h,03Fh
	db	07Fh,03Fh,0DBh,03Fh, 07Fh,03Fh,0F1h,03Fh, 07Fh,03Fh,01Dh,040h, 07Fh,03Fh,021h,040h
	db	07Fh,03Fh,025h,040h, 07Fh,03Fh,041h,040h, 07Fh,03Fh,001h,041h, 07Fh,03Fh,01Dh,041h
	db	07Fh,03Fh,020h,041h, 07Fh,03Fh,023h,041h, 07Fh,03Fh,031h,041h

Pachinko:
	db	91
	db	07Fh,03Fh,008h,034h, 07Fh,03Fh,00Ch,034h, 07Fh,03Fh,010h,034h, 07Fh,03Fh,014h,034h
	db	099h,0BFh,0F1h,043h, 0DCh,0A2h,029h,0B2h, 04Fh,0F6h,02Ah,0B2h, 0DBh,0C0h,02Bh,0B2h
	db	0DDh,04Fh,02Ch,0B2h, 0DCh,0A2h,03Ch,0B2h, 0DBh,03Eh,049h,0B2h, 0DDh,0FFh,04Ah,0B2h
	db	0D3h,0DBh,05Bh,0B2h, 0DEh,0A2h,05Ch,0C2h, 0DBh,0F6h,05Dh,0C2h, 0DCh,0C0h,05Eh,0B2h
	db	0DBh,03Eh,066h,0B2h, 0DDh,0FFh,067h,0B2h, 0DCh,0A2h,078h,0B2h, 0DBh,03Eh,085h,0B2h
	db	0DDh,0FFh,086h,0B2h, 0DCh,0A2h,09Bh,0B2h, 0DCh,0A2h,0A7h,0B2h, 0DCh,0A2h,0B3h,0B2h
	db	0DCh,0A2h,0C5h,0B2h, 07Fh,03Fh,0BAh,0B3h, 07Fh,03Fh,008h,0B6h, 07Fh,03Fh,01Bh,0B6h
	db	0DCh,0A2h,029h,0BAh, 04Fh,0F6h,02Ah,0BAh, 0DBh,0C0h,02Bh,0BAh, 0DDh,04Fh,02Ch,0BAh
	db	0DCh,0A2h,03Ch,0BAh, 0DBh,03Eh,049h,0BAh, 0DDh,0FFh,04Ah,0BAh, 0DCh,0A2h,05Eh,0BAh
	db	0DBh,03Eh,066h,0BAh, 0DDh,0FFh,067h,0BAh, 0DCh,0A2h,078h,0BAh, 0DBh,03Eh,085h,0BAh
	db	0DDh,0FFh,086h,0BAh, 0DCh,0A2h,09Bh,0BAh, 0DCh,0A2h,0A7h,0BAh, 0DCh,0A2h,0B3h,0BAh
	db	0DCh,0A2h,0C5h,0BAh, 07Fh,03Fh,0BAh,0BBh, 07Fh,03Fh,008h,0BEh, 07Fh,03Fh,01Bh,0BEh
	db	0DCh,0A2h,029h,0C2h, 04Fh,0F6h,02Ah,0C2h, 0DBh,0C0h,02Bh,0C2h, 0DDh,04Fh,02Ch,0C2h
	db	0DCh,0A2h,03Ch,0C2h, 0DBh,03Eh,049h,0C2h, 0DDh,0FFh,04Ah,0C2h, 0D3h,0DBh,05Bh,0C2h
	db	0DEh,0A2h,05Ch,0C2h, 0DBh,0F6h,05Dh,0C2h, 0DCh,0C0h,05Eh,0C2h, 0DBh,03Eh,066h,0C2h
	db	0DDh,0FFh,067h,0C2h, 0DCh,0A2h,078h,0C2h, 0DBh,03Eh,085h,0C2h, 0DDh,0FFh,086h,0C2h
	db	0DCh,0A2h,09Bh,0C2h, 0DCh,0A2h,0A7h,0C2h, 0DCh,0A2h,0B3h,0C2h, 0DCh,0A2h,0C5h,0C2h
	db	07Fh,03Fh,0BAh,0C3h, 07Fh,03Fh,008h,0C6h, 07Fh,03Fh,01Bh,0C6h, 0DCh,0A2h,029h,0CAh
	db	04Fh,0F6h,02Ah,0CAh, 0DBh,0C0h,02Bh,0CAh, 0DDh,04Fh,02Ch,0CAh, 0DCh,0A2h,03Ch,0CAh
	db	0DBh,03Eh,049h,0CAh, 0DDh,0FFh,04Ah,0CAh, 0DCh,0A2h,05Eh,0CAh, 0DBh,03Eh,066h,0CAh
	db	0DDh,0FFh,067h,0CAh, 0DCh,0A2h,078h,0CAh, 0DBh,03Eh,085h,0CAh, 0DDh,0FFh,086h,0CAh
	db	0DCh,0A2h,09Bh,0CAh, 0DCh,0A2h,0A7h,0CAh, 0DCh,0A2h,0B3h,0CAh, 0DCh,0A2h,0C5h,0CAh
	db	07Fh,03Fh,0BAh,0CBh, 07Fh,03Fh,008h,0CEh, 07Fh,03Fh,01Bh,0CEh

Pachinko2:
	db	32
	db	07Fh,03Fh,038h,032h, 07Fh,03Fh,03Ch,032h, 07Fh,03Fh,040h,032h, 07Fh,03Fh,044h,032h
	db	0DCh,0A2h,065h,04Bh, 04Fh,0F6h,066h,04Bh, 0DBh,0C0h,067h,04Bh, 0DDh,04Fh,068h,04Bh
	db	0DCh,0A2h,078h,04Bh, 0DBh,03Eh,085h,04Bh, 0DDh,0FFh,086h,04Bh, 0DCh,0A2h,09Ah,04Bh
	db	0DBh,03Eh,0A2h,04Bh, 0DDh,0FFh,0A3h,04Bh, 0DCh,0A2h,0B4h,04Bh, 0DBh,03Eh,0C1h,04Bh
	db	0DDh,0FFh,0C2h,04Bh, 0DCh,0A2h,0D7h,04Bh, 0DCh,0A2h,0E3h,04Bh, 0DCh,0A2h,0EFh,04Bh
	db	0DCh,0A2h,001h,04Ch, 099h,0BFh,06Eh,064h, 07Fh,03Fh,06Eh,067h, 07Fh,03Fh,073h,067h
	db	07Fh,03Fh,0C3h,067h, 07Fh,03Fh,0D7h,067h, 07Fh,03Fh,0C0h,06Ah, 07Fh,03Fh,0D3h,06Ah
	db	07Fh,03Fh,0E6h,06Ah, 07Fh,03Fh,0F9h,06Ah, 07Fh,03Fh,00Ch,06Bh, 07Fh,03Fh,01Fh,06Bh

Pitfall2:	; Only 1 player supported
	db	43
	db	07Fh,03Fh,089h,031h, 07Fh,03Fh,08Dh,031h, 07Fh,03Fh,091h,031h, 07Fh,03Fh,095h,031h
	db	0DCh,0A2h,03Ah,056h, 0DBh,03Eh,045h,056h, 0DDh,0FFh,046h,056h, 0DCh,0A2h,053h,056h
	db	0DBh,03Eh,060h,056h, 0DDh,0FFh,061h,056h, 0DCh,0A2h,077h,056h, 0DBh,03Eh,082h,056h
	db	0DDh,0FFh,083h,056h, 0DCh,0A2h,094h,056h, 0DBh,03Eh,0A1h,056h, 0DDh,0FFh,0A2h,056h
	db	0DBh,03Eh,0BDh,056h, 0DDh,0FFh,0BEh,056h, 0DBh,03Eh,0C9h,056h, 0DDh,0FFh,0CAh,056h
	db	0DCh,0A2h,0D6h,056h, 0DCh,0A2h,0E8h,056h, 0DCh,0A2h,0F4h,056h, 0DCh,0A2h,002h,057h
	db	0DCh,0A2h,00Eh,057h, 0DCh,0A2h,01Ah,057h, 0DCh,0A2h,026h,057h, 0DCh,0A2h,032h,057h
	db	0DCh,0A2h,044h,057h, 0DCh,0A2h,050h,057h, 0DBh,03Eh,05Bh,057h, 0DDh,0FFh,05Ch,057h
	db	0DBh,03Eh,067h,057h, 0DDh,0FFh,068h,057h, 07Fh,03Fh,04Bh,067h, 07Fh,03Fh,063h,067h
	db	07Fh,03Fh,082h,067h, 07Fh,03Fh,09Ah,067h, 07Fh,03Fh,0ACh,067h, 07Fh,03Fh,0C4h,067h
	db	07Fh,03Fh,0DAh,067h, 07Fh,03Fh,0AFh,06Ah, 07Fh,03Fh,0C6h,06Ah

PopFlamer:	; 2 players supported
	db	15
	db	0BFh,099h,083h,030h, 0BFh,099h,00Dh,033h, 0D3h,000h,0E9h,033h, 0DEh,0CDh,0EAh,033h
	db	0DBh,020h,0EBh,033h, 0DCh,0F4h,0ECh,033h, 0D3h,000h,0F9h,033h, 0DEh,0CDh,0FAh,033h
	db	0DBh,04Ch,0FBh,033h, 0DDh,0F4h,0FCh,033h, 0CDh,0C3h,0D6h,064h, 07Fh,03Fh,011h,06Ah
	db	07Fh,03Fh,029h,06Ah, 07Fh,03Fh,0C8h,06Ch, 07Fh,03Fh,0E0h,06Ch

PowerBoggle:
	db	18
	db	0BEh,098h,006h,030h, 0BEh,098h,007h,030h, 07Fh,03Fh,06Eh,06Fh, 07Fh,03Fh,091h,06Fh
	db	07Fh,03Fh,0A4h,06Fh, 07Fh,03Fh,0B2h,06Fh, 07Fh,03Fh,0D5h,06Fh, 07Fh,03Fh,0DDh,06Fh
	db	0EDh,000h,009h,09Fh, 079h,000h,00Ah,09Fh, 077h,000h,012h,09Fh, 077h,0C9h,015h,09Fh
	db	07Fh,03Fh,0E9h,0AEh, 07Fh,03Fh,0FCh,0AEh, 07Fh,03Fh,00Ah,0AFh, 07Fh,03Fh,041h,0AFh
	db	07Fh,03Fh,059h,0AFh, 0DCh,0A2h,061h,0AFh

Puznic:
	db	7
	db	0DCh,0A2h,097h,030h, 07Fh,03Fh,043h,071h, 07Fh,03Fh,066h,071h, 07Fh,03Fh,079h,071h
	db	07Fh,03Fh,0AAh,071h, 07Fh,03Fh,0B2h,071h, 0DCh,0A2h,0BCh,071h

QBert:
	db	18
	db	0BFh,099h,031h,030h, 0BFh,099h,04Eh,030h, 0DCh,0A2h,089h,031h, 0DCh,0A2h,092h,031h
	db	0DCh,0A2h,0C3h,031h, 0DCh,0A2h,0CFh,031h, 0DCh,0A2h,0DBh,031h, 0DCh,0A2h,0E7h,031h
	db	0DCh,0A2h,0F3h,031h, 0BFh,099h,050h,039h, 0BEh,098h,058h,03Ch, 0BFh,099h,03Bh,03Dh
	db	0BEh,098h,045h,03Dh, 0BEh,098h,070h,03Dh, 0BEh,098h,076h,03Dh, 0BEh,098h,07Ch,03Dh
	db	0BEh,098h,09Ch,03Eh, 07Fh,03Fh,0C7h,044h

RocknBolt:	; Only 1 player supported, Works on MSX1 only
	db	43
	db	0BFh,099h,0E8h,038h, 0BEh,098h,0F1h,038h, 0BFh,099h,0F4h,038h, 0BEh,098h,0FDh,038h
	db	0BFh,099h,000h,039h, 0BEh,098h,006h,039h, 0BFh,099h,0C4h,03Ch, 0BEh,098h,0CAh,03Ch
	db	0BEh,098h,06Bh,03Eh, 0BFh,099h,096h,045h, 0BFh,099h,0CCh,045h, 0BFh,099h,0DDh,045h
	db	0BEh,098h,0E6h,045h, 0BFh,099h,0F0h,045h, 0BEh,098h,0F9h,045h, 0BFh,099h,003h,046h
	db	0BEh,098h,00Ch,046h, 0BFh,099h,017h,046h, 0BFh,099h,02Eh,046h, 0BEh,098h,037h,046h
	db	0BFh,099h,062h,046h, 0BEh,098h,06Bh,046h, 0BFh,099h,09Ch,046h, 0BEh,098h,0A5h,046h
	db	0BFh,099h,0E3h,04Bh, 0BEh,098h,0ECh,04Bh, 0DCh,0A2h,0E4h,055h, 04Fh,0F6h,0E5h,055h
	db	0F6h,0C0h,0E6h,055h, 0C0h,04Fh,0E7h,055h, 0DCh,0A2h,0FCh,055h, 04Fh,0F6h,0FDh,055h
	db	0F6h,0C0h,0FEh,055h, 0C0h,04Fh,0FFh,055h, 0DCh,0A2h,015h,056h, 0DCh,0A2h,027h,056h
	db	0DCh,0A2h,039h,056h, 0DCh,0A2h,04Bh,056h, 0DCh,0A2h,057h,056h, 0DCh,0A2h,063h,056h
	db	0BFh,099h,05Fh,057h, 07Fh,03Fh,0B2h,09Eh, 07Fh,03Fh,0C8h,09Eh

SafariHunt:
	db	10
	db	07Fh,03Fh,057h,045h, 0DCh,0A2h,0B2h,05Ch, 0DBh,03Eh,0C3h,05Ch, 0DDh,0FFh,0C4h,05Ch
	db	07Fh,03Fh,0C8h,061h, 07Fh,03Fh,0DBh,061h, 07Fh,03Fh,0EEh,061h, 07Fh,03Fh,001h,062h
	db	07Fh,03Fh,014h,062h, 07Fh,03Fh,027h,062h

SafariRace:
	db	29
	db	07Fh,03Fh,018h,032h, 07Fh,03Fh,01Ch,032h, 07Fh,03Fh,020h,032h, 07Fh,03Fh,024h,032h
	db	0DCh,0A2h,0E7h,064h, 0DBh,03Eh,0E9h,064h, 0DDh,0FFh,0EAh,064h, 0DCh,0A2h,0FAh,064h
	db	0DBh,03Eh,007h,065h, 0DDh,0FFh,008h,065h, 0DCh,03Eh,01Ch,065h, 0DBh,03Eh,024h,065h
	db	0DDh,0FFh,025h,065h, 0DCh,03Eh,036h,065h, 0DBh,03Eh,043h,065h, 0DDh,0FFh,044h,065h
	db	0DCh,03Eh,057h,065h, 0DCh,03Eh,063h,065h, 0DCh,03Eh,06Fh,065h, 0DCh,03Eh,07Bh,065h
	db	0DCh,03Eh,087h,065h, 0DCh,03Eh,099h,065h, 0DCh,03Eh,0A5h,065h, 0C0h,0C1h,01Fh,0A1h
	db	0E0h,0E1h,03Fh,0A1h, 07Fh,03Fh,02Fh,0A4h, 07Fh,03Fh,039h,0A4h, 07Fh,03Fh,0E0h,0A6h
	db	07Fh,03Fh,0F3h,0A6h

SanNinMahjong:
	db	19
	db	07Fh,03Fh,071h,030h, 07Fh,03Fh,075h,030h, 07Fh,03Fh,079h,030h, 07Fh,03Fh,07Dh,030h
	db	0BFh,099h,06Dh,032h, 07Fh,03Fh,014h,033h, 07Fh,03Fh,028h,033h, 07Fh,03Fh,03Ch,033h
	db	07Fh,03Fh,03Fh,033h, 07Fh,03Fh,042h,033h, 0DCh,0A2h,0F4h,033h, 0DCh,0A2h,000h,034h
	db	0DCh,0A2h,00Ch,034h, 0DCh,0A2h,018h,034h, 0DCh,0A2h,024h,034h, 0DCh,0A2h,03Bh,034h
	db	0DBh,03Eh,04Bh,034h, 0DDh,0FFh,04Ch,034h, 0DCh,0A2h,05Eh,034h

SerizawaTsumeshogi:
	db	9
	db	07Fh,03Fh,0B0h,038h, 07Fh,03Fh,0B4h,038h, 07Fh,03Fh,0B8h,038h, 07Fh,03Fh,0CEh,038h
	db	07Fh,03Fh,0D4h,038h, 07Fh,03Fh,0D8h,038h, 07Fh,03Fh,0DCh,038h, 07Fh,03Fh,0E0h,038h
	db	0DCh,0A2h,04Fh,03Ch

ShinnyushainTooruKun:	; 2 players supported
	db	65
	db	000h,0C3h,010h,030h, 000h,020h,011h,030h, 000h,0F4h,012h,030h, 000h,0C3h,018h,030h
	db	000h,04Ch,019h,030h, 000h,0F4h,01Ah,030h, 0DBh,000h,06Bh,044h, 0DCh,0D7h,06Ch,044h
	db	0DBh,000h,071h,044h, 0DDh,0DFh,072h,044h, 0D3h,000h,081h,044h, 0DEh,0CDh,082h,044h
	db	0DBh,020h,083h,044h, 0DCh,0F4h,084h,044h, 0D3h,000h,08Bh,044h, 0DEh,0CDh,08Ch,044h
	db	0DBh,04Ch,08Dh,044h, 0DDh,0F4h,08Eh,044h, 0D3h,000h,09Ah,044h, 0DEh,0CDh,09Bh,044h
	db	0DBh,020h,09Ch,044h, 0DCh,0F4h,09Dh,044h, 002h,005h,0A7h,044h, 0D3h,000h,0ACh,044h
	db	0DEh,0CDh,0ADh,044h, 0DBh,020h,0AEh,044h, 0DCh,0F4h,0AFh,044h, 002h,005h,0B9h,044h
	db	0D3h,000h,0BEh,044h, 0DEh,0CDh,0BFh,044h, 0DBh,020h,0C0h,044h, 0DCh,0F4h,0C1h,044h
	db	002h,005h,0CBh,044h, 0D3h,000h,0D0h,044h, 0DEh,0CDh,0D1h,044h, 0DBh,020h,0D2h,044h
	db	0DCh,0F4h,0D3h,044h, 002h,005h,0D7h,044h, 0D3h,000h,0DCh,044h, 0DEh,0CDh,0DDh,044h
	db	0DBh,020h,0DEh,044h, 0DCh,0F4h,0DFh,044h, 002h,005h,0E3h,044h, 0D3h,000h,0E8h,044h
	db	0DEh,0CDh,0E9h,044h, 0DBh,020h,0EAh,044h, 0DCh,0F4h,0EBh,044h, 002h,005h,0F5h,044h
	db	0D3h,000h,0FAh,044h, 0DEh,0CDh,0FBh,044h, 0DBh,04Ch,0FCh,044h, 0DDh,0F4h,0FDh,044h
	db	002h,005h,001h,045h, 0D3h,000h,006h,045h, 0DEh,0CDh,007h,045h, 0DBh,04Ch,008h,045h
	db	0DDh,0F4h,009h,045h, 07Fh,03Fh,0ADh,045h, 07Fh,03Fh,0B1h,045h, 07Fh,03Fh,0B5h,045h
	db	07Fh,03Fh,0B9h,045h, 0BEh,098h,081h,048h, 07Fh,03Fh,0DAh,0A0h, 07Fh,03Fh,0F2h,0A0h
	db	07Fh,03Fh,0FBh,0A0h

SpaceArmor:	; Works on MSX1 only
	db	19
	db	0BFh,099h,0D5h,030h, 0BFh,099h,0E0h,030h, 0DCh,0A2h,0C1h,039h, 0DBh,03Eh,0C9h,039h
	db	0DDh,0FFh,0CAh,039h, 0DCh,0A2h,0EAh,039h, 0DCh,0A2h,0F6h,039h, 0DCh,0A2h,002h,03Ah
	db	0DCh,0A2h,00Eh,03Ah, 0DCh,0A2h,01Ah,03Ah, 0DBh,03Eh,032h,03Ah, 0DDh,0FFh,033h,03Ah
	db	0DBh,03Eh,03Eh,03Ah, 0DDh,0FFh,03Fh,03Ah, 0DCh,0A2h,04Bh,03Ah, 0DCh,0A2h,057h,03Ah
	db	0DCh,0A2h,063h,03Ah, 07Fh,03Fh,084h,065h, 07Fh,03Fh,0A0h,065h

SpaceInvaders:
	db	24
	db	0DCh,0A2h,0ADh,035h, 0DCh,0A2h,0B5h,035h, 0DBh,03Eh,0B9h,035h, 0DDh,0FFh,0BAh,035h
	db	0DCh,0A2h,0CEh,035h, 0DCh,0A2h,0DAh,035h, 0DCh,0A2h,0E6h,035h, 0DCh,0A2h,0F2h,035h
	db	0DCh,0A2h,004h,036h, 0DCh,0A2h,010h,036h, 0DCh,0A2h,029h,036h, 0DCh,0A2h,03Bh,036h
	db	0DCh,0A2h,047h,036h, 0DBh,03Eh,052h,036h, 0DDh,0FFh,053h,036h, 0DBh,03Eh,05Eh,036h
	db	0DDh,0FFh,05Fh,036h, 0DCh,0A2h,06Dh,060h, 07Fh,03Fh,0E2h,060h, 07Fh,03Fh,001h,061h
	db	07Fh,03Fh,051h,061h, 07Fh,03Fh,08Fh,061h, 07Fh,03Fh,0C8h,063h, 07Fh,03Fh,0DFh,063h

SpaceMountain:
	db	17
	db	0BFh,099h,0A3h,030h, 0DCh,0A2h,0CDh,038h, 0DCh,0A2h,027h,039h, 0DCh,0A2h,031h,039h
	db	0DCh,0A2h,037h,039h, 0DCh,0A2h,03Eh,039h, 07Fh,03Fh,056h,039h, 07Fh,03Fh,083h,03Ch
	db	07Fh,03Fh,087h,03Ch, 07Fh,03Fh,0F6h,048h, 07Fh,03Fh,027h,049h, 07Fh,03Fh,038h,049h
	db	07Fh,03Fh,043h,049h, 07Fh,03Fh,048h,049h, 07Fh,03Fh,04Ch,049h, 07Fh,03Fh,050h,049h
	db	07Fh,03Fh,0A6h,049h

StarForce:
	db	23
	db	0BEh,098h,07Dh,031h, 0BEh,098h,0A4h,031h, 07Fh,03Fh,096h,032h, 07Fh,03Fh,09Ah,032h
	db	07Fh,03Fh,09Eh,032h, 07Fh,03Fh,0A2h,032h, 0DCh,0A2h,05Ch,058h, 0DCh,0A2h,06Bh,058h
	db	0DCh,0A2h,07Fh,058h, 0DCh,0A2h,088h,058h, 0DCh,0A2h,09Bh,058h, 0DCh,0A2h,0A7h,058h
	db	0DCh,0A2h,0B3h,058h, 0DCh,0A2h,0BFh,058h, 0DCh,0A2h,0CBh,058h, 0DCh,0A2h,0DDh,058h
	db	0DCh,0A2h,0E9h,058h, 07Fh,03Fh,07Fh,09Eh, 07Fh,03Fh,0CFh,09Eh, 07Fh,03Fh,0FAh,09Eh
	db	07Fh,03Fh,017h,09Fh, 07Fh,03Fh,056h,0A2h, 07Fh,03Fh,069h,0A2h

StarJackerV12:
	db	91
	db	000h,0C3h,020h,030h, 000h,020h,021h,030h, 000h,0F4h,022h,030h, 000h,0C3h,028h,030h
	db	000h,04Ch,029h,030h, 000h,0F4h,02Ah,030h, 07Fh,03Fh,0D8h,032h, 07Fh,03Fh,0DCh,032h
	db	07Fh,03Fh,0E0h,032h, 07Fh,03Fh,0E4h,032h, 07Fh,03Fh,0A4h,033h, 07Fh,03Fh,0A8h,033h
	db	07Fh,03Fh,0ACh,033h, 07Fh,03Fh,0B0h,033h, 0DBh,000h,0F6h,058h, 0DCh,0E7h,0F7h,058h
	db	0DBh,0EFh,002h,059h, 0DDh,0F4h,003h,059h, 0DBh,000h,00Fh,059h, 0DCh,0E7h,010h,059h
	db	0DBh,000h,01Dh,059h, 0DDh,0EFh,01Eh,059h, 0D3h,000h,02Fh,059h, 0DEh,0CDh,030h,059h
	db	0DBh,020h,031h,059h, 0DCh,0F4h,032h,059h, 0DBh,000h,03Dh,059h, 0DDh,0EFh,03Eh,059h
	db	0D3h,000h,04Ch,059h, 0DEh,0CDh,04Dh,059h, 0DBh,020h,04Eh,059h, 0DCh,0F4h,04Fh,059h
	db	0DBh,000h,05Ch,059h, 0DDh,0EFh,05Dh,059h, 0DBh,000h,078h,059h, 0DDh,0EFh,079h,059h
	db	0D3h,000h,082h,059h, 0DEh,0CDh,083h,059h, 0DBh,04Fh,084h,059h, 0DDh,0F4h,085h,059h
	db	0D3h,000h,08Eh,059h, 0DEh,0CDh,08Fh,059h, 0DBh,020h,090h,059h, 0DCh,0F4h,091h,059h
	db	0D3h,000h,0A0h,059h, 0DEh,0CDh,0A1h,059h, 0DBh,020h,0A2h,059h, 0DCh,0F4h,0A3h,059h
	db	0D3h,000h,0ACh,059h, 0DEh,0CDh,0ADh,059h, 0DBh,020h,0AEh,059h, 0DCh,0F4h,0AFh,059h
	db	0D3h,000h,0BAh,059h, 0DEh,0CDh,0BBh,059h, 0DBh,020h,0BCh,059h, 0DCh,0F4h,0BDh,059h
	db	0D3h,000h,0C6h,059h, 0DEh,0CDh,0C7h,059h, 0DBh,020h,0C8h,059h, 0DCh,0F4h,0C9h,059h
	db	0D3h,000h,0D2h,059h, 0DEh,0CDh,0D3h,059h, 0DBh,020h,0D4h,059h, 0DCh,0F4h,0D5h,059h
	db	0D3h,000h,0DEh,059h, 0DEh,0CDh,0DFh,059h, 0DBh,020h,0E0h,059h, 0DCh,0F4h,0E1h,059h
	db	0D3h,000h,0EAh,059h, 0DEh,0CDh,0EBh,059h, 0DBh,020h,0ECh,059h, 0DCh,0F4h,0EDh,059h
	db	0D3h,000h,0FCh,059h, 0DEh,0CDh,0FDh,059h, 0DBh,020h,0FEh,059h, 0DCh,0F4h,0FFh,059h
	db	0D3h,000h,008h,05Ah, 0DEh,0CDh,009h,05Ah, 0DBh,020h,00Ah,05Ah, 0DCh,0F4h,00Bh,05Ah
	db	0D3h,000h,014h,05Ah, 0DEh,0CDh,015h,05Ah, 0DBh,04Ch,016h,05Ah, 0DDh,0F4h,017h,05Ah
	db	0D3h,000h,020h,05Ah, 0DEh,0CDh,021h,05Ah, 0DBh,04Ch,022h,05Ah, 0DDh,0F4h,023h,05Ah
	db	07Fh,03Fh,0CBh,08Dh, 07Fh,03Fh,0E1h,08Dh, 07Fh,03Fh,000h,08Eh

SuperTank:	; 2 players supported
	db	24
	db	0D3h,0CDh,0FAh,05Bh, 0DEh,020h,0FBh,05Bh, 00Eh,0F4h,0FCh,05Bh, 0DCh,077h,0FDh,05Bh
	db	0EDh,02Ch,0FEh,05Bh, 0A2h,0CDh,0FFh,05Bh, 00Ch,04Ch,000h,05Ch, 0EDh,0F4h,001h,05Ch
	db	0A2h,077h,002h,05Ch, 0EDh,0CDh,057h,05Ch, 079h,020h,058h,05Ch, 0DBh,0F4h,059h,05Ch
	db	0DCh,02Fh,05Ah,05Ch, 02Fh,077h,05Bh,05Ch, 077h,023h,05Ch,05Ch, 023h,0CDh,05Dh,05Ch
	db	0DBh,04Ch,05Eh,05Ch, 0DDh,0F4h,05Fh,05Ch, 07Fh,03Fh,084h,062h, 07Fh,03Fh,088h,062h
	db	07Fh,03Fh,08Ch,062h, 07Fh,03Fh,090h,062h, 07Fh,03Fh,0D0h,074h, 07Fh,03Fh,0E6h,074h

TheBlackOnyx:
	db	7
	db	0DBh,03Eh,03Ah,033h, 0DDh,0FFh,03Bh,033h, 0DCh,0A2h,041h,033h, 07Fh,03Fh,065h,0A8h
	db	07Fh,03Fh,00Ch,0ABh, 07Fh,03Fh,039h,0ABh, 07Fh,03Fh,055h,0ABh

TheCastle:
	db	12
	db	0BFh,099h,0E6h,030h, 0DCh,0A2h,014h,032h, 0DCh,0A2h,01Dh,032h, 0DCh,0A2h,024h,032h
	db	0DCh,0A2h,030h,032h, 0DCh,0A2h,03Ch,032h, 0DCh,0A2h,04Eh,032h, 0DCh,0A2h,05Ah,032h
	db	0DCh,0A2h,064h,032h, 07Fh,03Fh,0E5h,039h, 07Fh,03Fh,036h,03Dh, 07Fh,03Fh,04Ch,03Dh

ThreeDragonStory:
	db	8
	db	0DCh,0A2h,025h,034h, 0DCh,0A2h,00Fh,057h, 07Fh,03Fh,0CEh,06Ch, 07Fh,03Fh,0F1h,06Ch
	db	07Fh,03Fh,004h,06Dh, 07Fh,03Fh,012h,06Dh, 07Fh,03Fh,035h,06Dh, 07Fh,03Fh,03Dh,06Dh

WonderBoy:
	db	25
	db	07Fh,03Fh,01Ah,030h, 0CDh,0C3h,0A9h,034h, 0CDh,0C3h,029h,037h, 0DCh,0A2h,032h,037h
	db	0DBh,03Eh,03Ch,037h, 0DDh,0FFh,03Dh,037h, 0DCh,0A2h,052h,037h, 0DCh,0A2h,064h,037h
	db	0DCh,0A2h,076h,037h, 0DCh,0A2h,088h,037h, 0DCh,0A2h,094h,037h, 0DBh,03Eh,09Bh,037h
	db	0DDh,0FFh,09Ch,037h, 0DCh,0A2h,0A8h,037h, 0DBh,03Eh,0B5h,037h, 0DDh,0FFh,0B6h,037h
	db	0CDh,0C3h,094h,054h, 07Fh,03Fh,03Ah,078h, 07Fh,03Fh,054h,078h, 07Fh,03Fh,058h,078h
	db	07Fh,03Fh,0A3h,078h, 07Fh,03Fh,0A7h,078h, 07Fh,03Fh,02Ch,07Bh, 07Fh,03Fh,09Dh,07Bh
	db	07Fh,03Fh,0B3h,07Bh

WonderBoyV1:
	db	25
	db	07Fh,03Fh,01Ah,030h, 0CDh,0C3h,0A9h,034h, 0CDh,0C3h,029h,037h, 0DCh,0A2h,032h,037h
	db	0DBh,03Eh,03Ch,037h, 0DDh,0FFh,03Dh,037h, 0DCh,0A2h,052h,037h, 0DCh,0A2h,064h,037h
	db	0DCh,0A2h,076h,037h, 0DCh,0A2h,088h,037h, 0DCh,0A2h,094h,037h, 0DBh,03Eh,09Bh,037h
	db	0DDh,0FFh,09Ch,037h, 0DCh,0A2h,0A8h,037h, 0DBh,03Eh,0B5h,037h, 0DDh,0FFh,0B6h,037h
	db	0CDh,0C3h,083h,055h, 0CDh,0C3h,091h,065h, 07Fh,03Fh,00Dh,079h, 07Fh,03Fh,027h,079h
	db	07Fh,03Fh,02Bh,079h, 07Fh,03Fh,076h,079h, 07Fh,03Fh,07Ah,079h, 07Fh,03Fh,0FFh,07Bh
	db	07Fh,03Fh,070h,07Ch

Yamato:
	db	24
	db	0BFh,099h,035h,031h, 0BFh,099h,02Ch,033h, 0BFh,099h,039h,034h, 0BFh,099h,08Bh,034h
	db	0BFh,099h,0CFh,034h, 0BFh,099h,0F1h,034h, 0BFh,099h,005h,035h, 0BFh,099h,021h,035h
	db	07Fh,03Fh,08Dh,035h, 07Fh,03Fh,091h,035h, 07Fh,03Fh,095h,035h, 07Fh,03Fh,099h,035h
	db	07Fh,03Fh,0DCh,035h, 07Fh,03Fh,0E1h,035h, 07Fh,03Fh,0E6h,035h, 0BFh,099h,03Ah,036h
	db	0D3h,000h,0BFh,046h, 0DEh,0CDh,0C0h,046h, 0DBh,020h,0C1h,046h, 0DCh,0F4h,0C2h,046h
	db	0D3h,000h,0D1h,046h, 0DEh,0CDh,0D2h,046h, 0DBh,04Ch,0D3h,046h, 0DDh,0F4h,0D4h,046h

Zaxxon:
	db	17
	db	07Fh,03Fh,06Bh,033h, 07Fh,03Fh,06Fh,033h, 07Fh,03Fh,073h,033h, 07Fh,03Fh,077h,033h
	db	0DCh,0A2h,097h,036h, 0DCh,0A2h,0A0h,036h, 0DCh,0A2h,0A9h,036h, 0DCh,0A2h,0B5h,036h
	db	0DCh,0A2h,056h,03Ah, 0DCh,0A2h,060h,03Ah, 0DCh,0A2h,06Ch,03Ah, 0DCh,0A2h,078h,03Ah
	db	0DCh,0A2h,084h,03Ah, 0DCh,0A2h,096h,03Ah, 0DCh,0A2h,0A2h,03Ah, 07Fh,03Fh,0C2h,09Ah
	db	07Fh,03Fh,0D5h,09Ah

ZippyRace:
	db	26
	db	07Fh,03Fh,00Fh,032h, 07Fh,03Fh,013h,032h, 07Fh,03Fh,0D7h,032h, 07Fh,03Fh,027h,036h
	db	07Fh,03Fh,03Ah,036h, 07Fh,03Fh,04Dh,036h, 07Fh,03Fh,060h,036h, 07Fh,03Fh,073h,036h
	db	07Fh,03Fh,086h,036h, 07Fh,03Fh,012h,040h, 0D3h,000h,0A7h,041h, 0DEh,0CDh,0A8h,041h
	db	0DBh,020h,0A9h,041h, 0DCh,0F4h,0AAh,041h, 0D3h,0CDh,0C6h,041h, 0DEh,020h,0C7h,041h
	db	0DBh,0F4h,0C8h,041h, 0DCh,02Fh,0C9h,041h, 02Fh,04Fh,0CAh,041h, 04Fh,0CDh,0CBh,041h
	db	0DBh,04Ch,0CCh,041h, 0DDh,0F4h,0CDh,041h, 07Fh,03Fh,0CCh,066h, 07Fh,03Fh,0D0h,066h
	db	07Fh,03Fh,0D4h,066h, 07Fh,03Fh,0D8h,066h

Zoom909:
	db	29
	db	0DCh,0A2h,008h,03Bh, 0DBh,03Eh,00Dh,03Bh, 0DDh,0FFh,00Eh,03Bh, 0DCh,0A2h,020h,03Bh
	db	0DBh,03Eh,029h,03Bh, 0DDh,0FFh,02Ah,03Bh, 0DCh,0A2h,039h,03Bh, 0DCh,0A2h,04Bh,03Bh
	db	0DCh,0A2h,05Dh,03Bh, 0DCh,0A2h,06Fh,03Bh, 0DCh,0A2h,07Bh,03Bh, 0DCh,0A2h,087h,03Bh
	db	0DBh,03Eh,098h,03Bh, 0DDh,0FFh,099h,03Bh, 0DBh,03Eh,0A4h,03Bh, 0DDh,0FFh,0A5h,03Bh
	db	07Fh,03Fh,0B2h,065h, 07Fh,03Fh,0B6h,065h, 07Fh,03Fh,0D0h,065h, 07Fh,03Fh,0D4h,065h
	db	07Fh,03Fh,0EFh,065h, 07Fh,03Fh,00Ah,066h, 07Fh,03Fh,032h,066h, 07Fh,03Fh,077h,066h
	db	07Fh,03Fh,07Bh,066h, 07Fh,03Fh,0DBh,066h, 07Fh,03Fh,0DFh,066h, 07Fh,03Fh,0A6h,069h
	db	07Fh,03Fh,0B9h,069h

; MSX Joypad routines

Joypad1:			; Start at 0F420h
	push	bc
	ld	a,15
	out	(0A0h),a
	in	a,(0A2h)	; Read register 15
	and	08Fh		; and 10001111
	out	(0A1h),a	; Select Joystick port 1

	ld	a,14
	out	(0A0h),a
	in	a,(0A2h)	; Read register 14
	and	03Fh
	ld	b,a
	
	ld	a,15
	out	(0A0h),a
	in	a,(0A2h)	; Read register 15
	or	040h		; and 01000000
	out	(0A1h),a	; Select Joystick port 2

	ld	a,14
	out	(0A0h),a
	in	a,(0A2h)	; Read register 14
	rra
	rra
	rra
	and	0C0h
	or	b
	pop	bc
	ret
	
Joypad2:			; Start at 0F44Ch
;	ld	a,15
;	out	(0A0h),a
;	in	a,(0A2h)	; Read register 15
;	or	040h		; and 01000000
;	out	(0A1h),a	; Select Joystick port 2

;	ld	a,14
;	out	(0A0h),a
	in	a,(0A2h)	; Read register 14
	rra
	rra
	or	0F0h
	ret
